@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobConfigurationManualTriggerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 */
public data class JobConfigurationManualTriggerConfigArgs(
    public val parallelism: Output<Int>? = null,
    public val replicaCompletionCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobConfigurationManualTriggerConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobConfigurationManualTriggerConfigArgs =
        com.pulumi.azurenative.app.inputs.JobConfigurationManualTriggerConfigArgs.builder()
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .replicaCompletionCount(replicaCompletionCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobConfigurationManualTriggerConfigArgs].
 */
@PulumiTagMarker
public class JobConfigurationManualTriggerConfigArgsBuilder internal constructor() {
    private var parallelism: Output<Int>? = null

    private var replicaCompletionCount: Output<Int>? = null

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("wdylhmdxavsdbmgw")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("mojthpgsaucshqrs")
    public suspend fun replicaCompletionCount(`value`: Output<Int>) {
        this.replicaCompletionCount = value
    }

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("lcjawfjuwuyqisau")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("ksaunjmgkrsjktdl")
    public suspend fun replicaCompletionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCompletionCount = mapped
    }

    internal fun build(): JobConfigurationManualTriggerConfigArgs =
        JobConfigurationManualTriggerConfigArgs(
            parallelism = parallelism,
            replicaCompletionCount = replicaCompletionCount,
        )
}
