@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobConfigurationScheduleTriggerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
 * @property cronExpression Cron formatted repeating schedule ("* * * * *") of a Cron Job.
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 */
public data class JobConfigurationScheduleTriggerConfigArgs(
    public val cronExpression: Output<String>,
    public val parallelism: Output<Int>? = null,
    public val replicaCompletionCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobConfigurationScheduleTriggerConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobConfigurationScheduleTriggerConfigArgs =
        com.pulumi.azurenative.app.inputs.JobConfigurationScheduleTriggerConfigArgs.builder()
            .cronExpression(cronExpression.applyValue({ args0 -> args0 }))
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .replicaCompletionCount(replicaCompletionCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobConfigurationScheduleTriggerConfigArgs].
 */
@PulumiTagMarker
public class JobConfigurationScheduleTriggerConfigArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    private var parallelism: Output<Int>? = null

    private var replicaCompletionCount: Output<Int>? = null

    /**
     * @param value Cron formatted repeating schedule ("* * * * *") of a Cron Job.
     */
    @JvmName("wmmadddeqilgtkox")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("vtyaaluyrjqwqyxw")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("ikcayevcnlqrymdx")
    public suspend fun replicaCompletionCount(`value`: Output<Int>) {
        this.replicaCompletionCount = value
    }

    /**
     * @param value Cron formatted repeating schedule ("* * * * *") of a Cron Job.
     */
    @JvmName("jxnfjcrfdyxiumut")
    public suspend fun cronExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("pqdhhtjotkrjlufo")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("rxbqumhcgeeietvj")
    public suspend fun replicaCompletionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCompletionCount = mapped
    }

    internal fun build(): JobConfigurationScheduleTriggerConfigArgs =
        JobConfigurationScheduleTriggerConfigArgs(
            cronExpression = cronExpression ?: throw PulumiNullFieldException("cronExpression"),
            parallelism = parallelism,
            replicaCompletionCount = replicaCompletionCount,
        )
}
