@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobScaleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scaling configurations for event driven jobs.
 * @property maxExecutions Maximum number of job executions that are created for a trigger, default 100.
 * @property minExecutions Minimum number of job executions that are created for a trigger, default 0
 * @property pollingInterval Interval to check each event source in seconds. Defaults to 30s
 * @property rules Scaling rules.
 */
public data class JobScaleArgs(
    public val maxExecutions: Output<Int>? = null,
    public val minExecutions: Output<Int>? = null,
    public val pollingInterval: Output<Int>? = null,
    public val rules: Output<List<JobScaleRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobScaleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobScaleArgs =
        com.pulumi.azurenative.app.inputs.JobScaleArgs.builder()
            .maxExecutions(maxExecutions?.applyValue({ args0 -> args0 }))
            .minExecutions(minExecutions?.applyValue({ args0 -> args0 }))
            .pollingInterval(pollingInterval?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobScaleArgs].
 */
@PulumiTagMarker
public class JobScaleArgsBuilder internal constructor() {
    private var maxExecutions: Output<Int>? = null

    private var minExecutions: Output<Int>? = null

    private var pollingInterval: Output<Int>? = null

    private var rules: Output<List<JobScaleRuleArgs>>? = null

    /**
     * @param value Maximum number of job executions that are created for a trigger, default 100.
     */
    @JvmName("ktglukfefwcvavxq")
    public suspend fun maxExecutions(`value`: Output<Int>) {
        this.maxExecutions = value
    }

    /**
     * @param value Minimum number of job executions that are created for a trigger, default 0
     */
    @JvmName("xflskelmjegampdn")
    public suspend fun minExecutions(`value`: Output<Int>) {
        this.minExecutions = value
    }

    /**
     * @param value Interval to check each event source in seconds. Defaults to 30s
     */
    @JvmName("ujxwsxrkyofuumbp")
    public suspend fun pollingInterval(`value`: Output<Int>) {
        this.pollingInterval = value
    }

    /**
     * @param value Scaling rules.
     */
    @JvmName("ecinbpqquxehgnmd")
    public suspend fun rules(`value`: Output<List<JobScaleRuleArgs>>) {
        this.rules = value
    }

    @JvmName("jofbpctlirloytjx")
    public suspend fun rules(vararg values: Output<JobScaleRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Scaling rules.
     */
    @JvmName("bjrkxyyhmutqjkil")
    public suspend fun rules(values: List<Output<JobScaleRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Maximum number of job executions that are created for a trigger, default 100.
     */
    @JvmName("nspoqbriqslbxnje")
    public suspend fun maxExecutions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxExecutions = mapped
    }

    /**
     * @param value Minimum number of job executions that are created for a trigger, default 0
     */
    @JvmName("qoefjrenjuilkemn")
    public suspend fun minExecutions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minExecutions = mapped
    }

    /**
     * @param value Interval to check each event source in seconds. Defaults to 30s
     */
    @JvmName("phlbqgbamgisdexi")
    public suspend fun pollingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingInterval = mapped
    }

    /**
     * @param value Scaling rules.
     */
    @JvmName("fqmfxvluqqvupero")
    public suspend fun rules(`value`: List<JobScaleRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("mmoucttggvcrxqku")
    public suspend fun rules(argument: List<suspend JobScaleRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobScaleRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("lkqpcpcgniuudhsb")
    public suspend fun rules(vararg argument: suspend JobScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobScaleRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Scaling rules.
     */
    @JvmName("rfocdwjangjonftj")
    public suspend fun rules(argument: suspend JobScaleRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JobScaleRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Scaling rules.
     */
    @JvmName("kpcngoyhhpfwxrkw")
    public suspend fun rules(vararg values: JobScaleRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): JobScaleArgs = JobScaleArgs(
        maxExecutions = maxExecutions,
        minExecutions = minExecutions,
        pollingInterval = pollingInterval,
        rules = rules,
    )
}
