@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.LoginArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
 * @property allowedExternalRedirectUrls External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
 * This is an advanced setting typically only needed by Windows Store application backends.
 * Note that URLs within the current domain are always implicitly allowed.
 * @property cookieExpiration The configuration settings of the session cookie's expiration.
 * @property nonce The configuration settings of the nonce used in the login flow.
 * @property preserveUrlFragmentsForLogins <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
 * @property routes The routes that specify the endpoints used for login and logout requests.
 */
public data class LoginArgs(
    public val allowedExternalRedirectUrls: Output<List<String>>? = null,
    public val cookieExpiration: Output<CookieExpirationArgs>? = null,
    public val nonce: Output<NonceArgs>? = null,
    public val preserveUrlFragmentsForLogins: Output<Boolean>? = null,
    public val routes: Output<LoginRoutesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.LoginArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.LoginArgs =
        com.pulumi.azurenative.app.inputs.LoginArgs.builder()
            .allowedExternalRedirectUrls(
                allowedExternalRedirectUrls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .cookieExpiration(cookieExpiration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nonce(nonce?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preserveUrlFragmentsForLogins(preserveUrlFragmentsForLogins?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LoginArgs].
 */
@PulumiTagMarker
public class LoginArgsBuilder internal constructor() {
    private var allowedExternalRedirectUrls: Output<List<String>>? = null

    private var cookieExpiration: Output<CookieExpirationArgs>? = null

    private var nonce: Output<NonceArgs>? = null

    private var preserveUrlFragmentsForLogins: Output<Boolean>? = null

    private var routes: Output<LoginRoutesArgs>? = null

    /**
     * @param value External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("eaxhmgqmsiggtdef")
    public suspend fun allowedExternalRedirectUrls(`value`: Output<List<String>>) {
        this.allowedExternalRedirectUrls = value
    }

    @JvmName("mpvvlacelsyygcxr")
    public suspend fun allowedExternalRedirectUrls(vararg values: Output<String>) {
        this.allowedExternalRedirectUrls = Output.all(values.asList())
    }

    /**
     * @param values External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("glvfouxokvyxmoxs")
    public suspend fun allowedExternalRedirectUrls(values: List<Output<String>>) {
        this.allowedExternalRedirectUrls = Output.all(values)
    }

    /**
     * @param value The configuration settings of the session cookie's expiration.
     */
    @JvmName("lhfdrllqbbyggeeh")
    public suspend fun cookieExpiration(`value`: Output<CookieExpirationArgs>) {
        this.cookieExpiration = value
    }

    /**
     * @param value The configuration settings of the nonce used in the login flow.
     */
    @JvmName("endrqfbqdirxsixs")
    public suspend fun nonce(`value`: Output<NonceArgs>) {
        this.nonce = value
    }

    /**
     * @param value <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
     */
    @JvmName("nwxbyklapgotxbmy")
    public suspend fun preserveUrlFragmentsForLogins(`value`: Output<Boolean>) {
        this.preserveUrlFragmentsForLogins = value
    }

    /**
     * @param value The routes that specify the endpoints used for login and logout requests.
     */
    @JvmName("shbqwxsmbwvpfptu")
    public suspend fun routes(`value`: Output<LoginRoutesArgs>) {
        this.routes = value
    }

    /**
     * @param value External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("qmppoyhjjtyuohyc")
    public suspend fun allowedExternalRedirectUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedExternalRedirectUrls = mapped
    }

    /**
     * @param values External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    @JvmName("atbrnxfsrwhacswt")
    public suspend fun allowedExternalRedirectUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedExternalRedirectUrls = mapped
    }

    /**
     * @param value The configuration settings of the session cookie's expiration.
     */
    @JvmName("plgqnjekvonpwfnd")
    public suspend fun cookieExpiration(`value`: CookieExpirationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieExpiration = mapped
    }

    /**
     * @param argument The configuration settings of the session cookie's expiration.
     */
    @JvmName("cacxhgfuwplydyws")
    public suspend fun cookieExpiration(argument: suspend CookieExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = CookieExpirationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cookieExpiration = mapped
    }

    /**
     * @param value The configuration settings of the nonce used in the login flow.
     */
    @JvmName("kqhxcalhnhlniang")
    public suspend fun nonce(`value`: NonceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonce = mapped
    }

    /**
     * @param argument The configuration settings of the nonce used in the login flow.
     */
    @JvmName("ptrsdhbpbdgumwjs")
    public suspend fun nonce(argument: suspend NonceArgsBuilder.() -> Unit) {
        val toBeMapped = NonceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nonce = mapped
    }

    /**
     * @param value <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
     */
    @JvmName("unlkacbotfkcfwyg")
    public suspend fun preserveUrlFragmentsForLogins(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveUrlFragmentsForLogins = mapped
    }

    /**
     * @param value The routes that specify the endpoints used for login and logout requests.
     */
    @JvmName("pldyiguuekrhkxjk")
    public suspend fun routes(`value`: LoginRoutesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument The routes that specify the endpoints used for login and logout requests.
     */
    @JvmName("rqwefpvvmwhowjft")
    public suspend fun routes(argument: suspend LoginRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = LoginRoutesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    internal fun build(): LoginArgs = LoginArgs(
        allowedExternalRedirectUrls = allowedExternalRedirectUrls,
        cookieExpiration = cookieExpiration,
        nonce = nonce,
        preserveUrlFragmentsForLogins = preserveUrlFragmentsForLogins,
        routes = routes,
    )
}
