@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.OpenIdConnectConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the endpoints used for the custom Open ID Connect provider.
 * @property authorizationEndpoint The endpoint to be used to make an authorization request.
 * @property certificationUri The endpoint that provides the keys necessary to validate the token.
 * @property issuer The endpoint that issues the token.
 * @property tokenEndpoint The endpoint to be used to request a token.
 * @property wellKnownOpenIdConfiguration The endpoint that contains all the configuration endpoints for the provider.
 */
public data class OpenIdConnectConfigArgs(
    public val authorizationEndpoint: Output<String>? = null,
    public val certificationUri: Output<String>? = null,
    public val issuer: Output<String>? = null,
    public val tokenEndpoint: Output<String>? = null,
    public val wellKnownOpenIdConfiguration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.OpenIdConnectConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.OpenIdConnectConfigArgs =
        com.pulumi.azurenative.app.inputs.OpenIdConnectConfigArgs.builder()
            .authorizationEndpoint(authorizationEndpoint?.applyValue({ args0 -> args0 }))
            .certificationUri(certificationUri?.applyValue({ args0 -> args0 }))
            .issuer(issuer?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint?.applyValue({ args0 -> args0 }))
            .wellKnownOpenIdConfiguration(wellKnownOpenIdConfiguration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenIdConnectConfigArgs].
 */
@PulumiTagMarker
public class OpenIdConnectConfigArgsBuilder internal constructor() {
    private var authorizationEndpoint: Output<String>? = null

    private var certificationUri: Output<String>? = null

    private var issuer: Output<String>? = null

    private var tokenEndpoint: Output<String>? = null

    private var wellKnownOpenIdConfiguration: Output<String>? = null

    /**
     * @param value The endpoint to be used to make an authorization request.
     */
    @JvmName("hdsbsaulhsxlddqe")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value The endpoint that provides the keys necessary to validate the token.
     */
    @JvmName("cbuhctaxyvdapfty")
    public suspend fun certificationUri(`value`: Output<String>) {
        this.certificationUri = value
    }

    /**
     * @param value The endpoint that issues the token.
     */
    @JvmName("dhssjcgekjxtaaiw")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The endpoint to be used to request a token.
     */
    @JvmName("hndegtxrixxjbeca")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value The endpoint that contains all the configuration endpoints for the provider.
     */
    @JvmName("luyhnogqwiegbkep")
    public suspend fun wellKnownOpenIdConfiguration(`value`: Output<String>) {
        this.wellKnownOpenIdConfiguration = value
    }

    /**
     * @param value The endpoint to be used to make an authorization request.
     */
    @JvmName("fimgshxnjmlybqsj")
    public suspend fun authorizationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value The endpoint that provides the keys necessary to validate the token.
     */
    @JvmName("bpfgirujrokbmgoc")
    public suspend fun certificationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificationUri = mapped
    }

    /**
     * @param value The endpoint that issues the token.
     */
    @JvmName("wdxiblemtwnusewi")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The endpoint to be used to request a token.
     */
    @JvmName("jmjpcrggqnwsydou")
    public suspend fun tokenEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value The endpoint that contains all the configuration endpoints for the provider.
     */
    @JvmName("unsfjrowryrtwvba")
    public suspend fun wellKnownOpenIdConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wellKnownOpenIdConfiguration = mapped
    }

    internal fun build(): OpenIdConnectConfigArgs = OpenIdConnectConfigArgs(
        authorizationEndpoint = authorizationEndpoint,
        certificationUri = certificationUri,
        issuer = issuer,
        tokenEndpoint = tokenEndpoint,
        wellKnownOpenIdConfiguration = wellKnownOpenIdConfiguration,
    )
}
