@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.OpenIdConnectRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the app registration for the custom Open ID Connect provider.
 * @property clientCredential The authentication credentials of the custom Open ID Connect provider.
 * @property clientId The client id of the custom Open ID Connect provider.
 * @property openIdConnectConfiguration The configuration settings of the endpoints used for the custom Open ID Connect provider.
 */
public data class OpenIdConnectRegistrationArgs(
    public val clientCredential: Output<OpenIdConnectClientCredentialArgs>? = null,
    public val clientId: Output<String>? = null,
    public val openIdConnectConfiguration: Output<OpenIdConnectConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.OpenIdConnectRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.OpenIdConnectRegistrationArgs =
        com.pulumi.azurenative.app.inputs.OpenIdConnectRegistrationArgs.builder()
            .clientCredential(clientCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .openIdConnectConfiguration(
                openIdConnectConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenIdConnectRegistrationArgs].
 */
@PulumiTagMarker
public class OpenIdConnectRegistrationArgsBuilder internal constructor() {
    private var clientCredential: Output<OpenIdConnectClientCredentialArgs>? = null

    private var clientId: Output<String>? = null

    private var openIdConnectConfiguration: Output<OpenIdConnectConfigArgs>? = null

    /**
     * @param value The authentication credentials of the custom Open ID Connect provider.
     */
    @JvmName("vkrlmrevduhywrph")
    public suspend fun clientCredential(`value`: Output<OpenIdConnectClientCredentialArgs>) {
        this.clientCredential = value
    }

    /**
     * @param value The client id of the custom Open ID Connect provider.
     */
    @JvmName("xsaevqbpdriusojt")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The configuration settings of the endpoints used for the custom Open ID Connect provider.
     */
    @JvmName("tqvjrjfpsptwkbgm")
    public suspend fun openIdConnectConfiguration(`value`: Output<OpenIdConnectConfigArgs>) {
        this.openIdConnectConfiguration = value
    }

    /**
     * @param value The authentication credentials of the custom Open ID Connect provider.
     */
    @JvmName("lwvkiyujjgnchmyw")
    public suspend fun clientCredential(`value`: OpenIdConnectClientCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCredential = mapped
    }

    /**
     * @param argument The authentication credentials of the custom Open ID Connect provider.
     */
    @JvmName("fvebdtkglueiwugf")
    public suspend
    fun clientCredential(argument: suspend OpenIdConnectClientCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = OpenIdConnectClientCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientCredential = mapped
    }

    /**
     * @param value The client id of the custom Open ID Connect provider.
     */
    @JvmName("wwnrvclsywduqmwq")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The configuration settings of the endpoints used for the custom Open ID Connect provider.
     */
    @JvmName("dywqjlvbovxpbhtr")
    public suspend fun openIdConnectConfiguration(`value`: OpenIdConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openIdConnectConfiguration = mapped
    }

    /**
     * @param argument The configuration settings of the endpoints used for the custom Open ID Connect provider.
     */
    @JvmName("fbfnsiojhvqjqsha")
    public suspend
    fun openIdConnectConfiguration(argument: suspend OpenIdConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = OpenIdConnectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.openIdConnectConfiguration = mapped
    }

    internal fun build(): OpenIdConnectRegistrationArgs = OpenIdConnectRegistrationArgs(
        clientCredential = clientCredential,
        clientId = clientId,
        openIdConnectConfiguration = openIdConnectConfiguration,
    )
}
