@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.RegistryCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App Private Registry
 * @property identity A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
 * @property passwordSecretRef The name of the Secret that contains the registry login password
 * @property server Container Registry Server
 * @property username Container Registry Username
 */
public data class RegistryCredentialsArgs(
    public val identity: Output<String>? = null,
    public val passwordSecretRef: Output<String>? = null,
    public val server: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.RegistryCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.RegistryCredentialsArgs =
        com.pulumi.azurenative.app.inputs.RegistryCredentialsArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .passwordSecretRef(passwordSecretRef?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryCredentialsArgs].
 */
@PulumiTagMarker
public class RegistryCredentialsArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var passwordSecretRef: Output<String>? = null

    private var server: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
     */
    @JvmName("tsyooqbaqtlijkmx")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value The name of the Secret that contains the registry login password
     */
    @JvmName("mklqbygxrfgfknes")
    public suspend fun passwordSecretRef(`value`: Output<String>) {
        this.passwordSecretRef = value
    }

    /**
     * @param value Container Registry Server
     */
    @JvmName("gvqqhyruetcwaenr")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value Container Registry Username
     */
    @JvmName("merlpyvdixlepjam")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
     */
    @JvmName("onenfrdqcolhbwvw")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value The name of the Secret that contains the registry login password
     */
    @JvmName("mihbyvttntsmheef")
    public suspend fun passwordSecretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecretRef = mapped
    }

    /**
     * @param value Container Registry Server
     */
    @JvmName("otaujfkylcshcgse")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Container Registry Username
     */
    @JvmName("wqsaoggqwywkfile")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): RegistryCredentialsArgs = RegistryCredentialsArgs(
        identity = identity,
        passwordSecretRef = passwordSecretRef,
        server = server,
        username = username,
    )
}
