@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.RegistryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App registry information.
 * @property registryPassword registry secret.
 * @property registryUrl registry server Url.
 * @property registryUserName registry username.
 */
public data class RegistryInfoArgs(
    public val registryPassword: Output<String>? = null,
    public val registryUrl: Output<String>? = null,
    public val registryUserName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.RegistryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.RegistryInfoArgs =
        com.pulumi.azurenative.app.inputs.RegistryInfoArgs.builder()
            .registryPassword(registryPassword?.applyValue({ args0 -> args0 }))
            .registryUrl(registryUrl?.applyValue({ args0 -> args0 }))
            .registryUserName(registryUserName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryInfoArgs].
 */
@PulumiTagMarker
public class RegistryInfoArgsBuilder internal constructor() {
    private var registryPassword: Output<String>? = null

    private var registryUrl: Output<String>? = null

    private var registryUserName: Output<String>? = null

    /**
     * @param value registry secret.
     */
    @JvmName("uusafnodkingsmyy")
    public suspend fun registryPassword(`value`: Output<String>) {
        this.registryPassword = value
    }

    /**
     * @param value registry server Url.
     */
    @JvmName("bfnnhdxkqtwnxtiv")
    public suspend fun registryUrl(`value`: Output<String>) {
        this.registryUrl = value
    }

    /**
     * @param value registry username.
     */
    @JvmName("kyjrhumhnaykrkxv")
    public suspend fun registryUserName(`value`: Output<String>) {
        this.registryUserName = value
    }

    /**
     * @param value registry secret.
     */
    @JvmName("dexrqoaujfhsqagu")
    public suspend fun registryPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryPassword = mapped
    }

    /**
     * @param value registry server Url.
     */
    @JvmName("jnocynkxjqvrnppj")
    public suspend fun registryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryUrl = mapped
    }

    /**
     * @param value registry username.
     */
    @JvmName("berxafsmdrpjjgdc")
    public suspend fun registryUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryUserName = mapped
    }

    internal fun build(): RegistryInfoArgs = RegistryInfoArgs(
        registryPassword = registryPassword,
        registryUrl = registryUrl,
        registryUserName = registryUserName,
    )
}
