@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.SecretVolumeItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Secret to be added to volume.
 * @property path Path to project secret to. If no path is provided, path defaults to name of secret listed in secretRef.
 * @property secretRef Name of the Container App secret from which to pull the secret value.
 */
public data class SecretVolumeItemArgs(
    public val path: Output<String>? = null,
    public val secretRef: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.SecretVolumeItemArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.SecretVolumeItemArgs =
        com.pulumi.azurenative.app.inputs.SecretVolumeItemArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .secretRef(secretRef?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretVolumeItemArgs].
 */
@PulumiTagMarker
public class SecretVolumeItemArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var secretRef: Output<String>? = null

    /**
     * @param value Path to project secret to. If no path is provided, path defaults to name of secret listed in secretRef.
     */
    @JvmName("ufaqtkicpuonqpxp")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Name of the Container App secret from which to pull the secret value.
     */
    @JvmName("uenenpjqiyyxytuh")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Path to project secret to. If no path is provided, path defaults to name of secret listed in secretRef.
     */
    @JvmName("hrcxtkteacneqcgf")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Name of the Container App secret from which to pull the secret value.
     */
    @JvmName("mcluossqgmaycjtl")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    internal fun build(): SecretVolumeItemArgs = SecretVolumeItemArgs(
        path = path,
        secretRef = secretRef,
    )
}
