@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App versioned application definition.
 * Defines the desired state of an immutable revision.
 * Any changes to this section Will result in a new revision being created
 * @property containers List of container definitions for the Container App.
 * @property initContainers List of specialized containers that run before app containers.
 * @property revisionSuffix User friendly suffix that is appended to the revision name
 * @property scale Scaling properties for the Container App.
 * @property volumes List of volume definitions for the Container App.
 */
public data class TemplateArgs(
    public val containers: Output<List<ContainerArgs>>? = null,
    public val initContainers: Output<List<InitContainerArgs>>? = null,
    public val revisionSuffix: Output<String>? = null,
    public val scale: Output<ScaleArgs>? = null,
    public val volumes: Output<List<VolumeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.TemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.TemplateArgs =
        com.pulumi.azurenative.app.inputs.TemplateArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .initContainers(
                initContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .revisionSuffix(revisionSuffix?.applyValue({ args0 -> args0 }))
            .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var containers: Output<List<ContainerArgs>>? = null

    private var initContainers: Output<List<InitContainerArgs>>? = null

    private var revisionSuffix: Output<String>? = null

    private var scale: Output<ScaleArgs>? = null

    private var volumes: Output<List<VolumeArgs>>? = null

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("lsmxihiudinnmaiy")
    public suspend fun containers(`value`: Output<List<ContainerArgs>>) {
        this.containers = value
    }

    @JvmName("kkciniyctdhrvuke")
    public suspend fun containers(vararg values: Output<ContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("amjogkvpwnjnbtit")
    public suspend fun containers(values: List<Output<ContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value List of specialized containers that run before app containers.
     */
    @JvmName("toebogtwgbnmkydb")
    public suspend fun initContainers(`value`: Output<List<InitContainerArgs>>) {
        this.initContainers = value
    }

    @JvmName("vgfgxoooyoyxwcbk")
    public suspend fun initContainers(vararg values: Output<InitContainerArgs>) {
        this.initContainers = Output.all(values.asList())
    }

    /**
     * @param values List of specialized containers that run before app containers.
     */
    @JvmName("rhfjdpwvphopqqwu")
    public suspend fun initContainers(values: List<Output<InitContainerArgs>>) {
        this.initContainers = Output.all(values)
    }

    /**
     * @param value User friendly suffix that is appended to the revision name
     */
    @JvmName("efjbpdauankwsxie")
    public suspend fun revisionSuffix(`value`: Output<String>) {
        this.revisionSuffix = value
    }

    /**
     * @param value Scaling properties for the Container App.
     */
    @JvmName("shewnllehthnwkup")
    public suspend fun scale(`value`: Output<ScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value List of volume definitions for the Container App.
     */
    @JvmName("swqblbjwacftbbed")
    public suspend fun volumes(`value`: Output<List<VolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("ixflqbnugkcviuib")
    public suspend fun volumes(vararg values: Output<VolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values List of volume definitions for the Container App.
     */
    @JvmName("kubsadmtnxkgrnxo")
    public suspend fun volumes(values: List<Output<VolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("kgwublyshbijouuv")
    public suspend fun containers(`value`: List<ContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("cnjbalkpdxjsoabg")
    public suspend fun containers(argument: List<suspend ContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("eqnwjaxptobqwlmx")
    public suspend fun containers(vararg argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("cssgdfvjloeyxpqu")
    public suspend fun containers(argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("vdqbwhwkshweinio")
    public suspend fun containers(vararg values: ContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value List of specialized containers that run before app containers.
     */
    @JvmName("rmfxaqwmjlqfwokr")
    public suspend fun initContainers(`value`: List<InitContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("gwgeflubmpccwwho")
    public suspend fun initContainers(argument: List<suspend InitContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("aptebhpiwrcclnyp")
    public suspend fun initContainers(vararg argument: suspend InitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("ymvxpfrabypndgwy")
    public suspend fun initContainers(argument: suspend InitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InitContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param values List of specialized containers that run before app containers.
     */
    @JvmName("urgmkhxavlubetwb")
    public suspend fun initContainers(vararg values: InitContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param value User friendly suffix that is appended to the revision name
     */
    @JvmName("wxixcwphmtyjyqib")
    public suspend fun revisionSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revisionSuffix = mapped
    }

    /**
     * @param value Scaling properties for the Container App.
     */
    @JvmName("dbjnlfrelvpfajwj")
    public suspend fun scale(`value`: ScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument Scaling properties for the Container App.
     */
    @JvmName("pmqseekqgxskrwpv")
    public suspend fun scale(argument: suspend ScaleArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    /**
     * @param value List of volume definitions for the Container App.
     */
    @JvmName("uejwwrcntffevmur")
    public suspend fun volumes(`value`: List<VolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("bdgsxkhjyiijuxmd")
    public suspend fun volumes(argument: List<suspend VolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("aewsaqbevsjiynxc")
    public suspend fun volumes(vararg argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("ttxtksiycjqrcsux")
    public suspend fun volumes(argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values List of volume definitions for the Container App.
     */
    @JvmName("naoythocvvvrhsmh")
    public suspend fun volumes(vararg values: VolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        containers = containers,
        initContainers = initContainers,
        revisionSuffix = revisionSuffix,
        scale = scale,
        volumes = volumes,
    )
}
