@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.TwitterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Twitter provider.
 * @property enabled <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property registration The configuration settings of the app registration for the Twitter provider.
 */
public data class TwitterArgs(
    public val enabled: Output<Boolean>? = null,
    public val registration: Output<TwitterRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.TwitterArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.TwitterArgs =
        com.pulumi.azurenative.app.inputs.TwitterArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TwitterArgs].
 */
@PulumiTagMarker
public class TwitterArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var registration: Output<TwitterRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("qbdgemklbwolttkm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the app registration for the Twitter provider.
     */
    @JvmName("viwonhkiwlpejfls")
    public suspend fun registration(`value`: Output<TwitterRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("ntuvhqnnuyjrycuh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the app registration for the Twitter provider.
     */
    @JvmName("sguspgkatciscngp")
    public suspend fun registration(`value`: TwitterRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the app registration for the Twitter provider.
     */
    @JvmName("vwgsrqdcylqbmcnc")
    public suspend fun registration(argument: suspend TwitterRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = TwitterRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): TwitterArgs = TwitterArgs(
        enabled = enabled,
        registration = registration,
    )
}
