@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.VolumeArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.StorageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Volume definitions for the Container App.
 * @property mountOptions Mount options used while mounting the AzureFile. Must be a comma-separated string.
 * @property name Volume name.
 * @property secrets List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
 * @property storageName Name of storage resource. No need to provide for EmptyDir and Secret.
 * @property storageType Storage type for the volume. If not provided, use EmptyDir.
 */
public data class VolumeArgs(
    public val mountOptions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val secrets: Output<List<SecretVolumeItemArgs>>? = null,
    public val storageName: Output<String>? = null,
    public val storageType: Output<Either<String, StorageType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.VolumeArgs =
        com.pulumi.azurenative.app.inputs.VolumeArgs.builder()
            .mountOptions(mountOptions?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageName(storageName?.applyValue({ args0 -> args0 }))
            .storageType(
                storageType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var mountOptions: Output<String>? = null

    private var name: Output<String>? = null

    private var secrets: Output<List<SecretVolumeItemArgs>>? = null

    private var storageName: Output<String>? = null

    private var storageType: Output<Either<String, StorageType>>? = null

    /**
     * @param value Mount options used while mounting the AzureFile. Must be a comma-separated string.
     */
    @JvmName("rmoofmclsqdelixo")
    public suspend fun mountOptions(`value`: Output<String>) {
        this.mountOptions = value
    }

    /**
     * @param value Volume name.
     */
    @JvmName("ayrjeubtosbnlpdc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("dvatmxvwosagcmqe")
    public suspend fun secrets(`value`: Output<List<SecretVolumeItemArgs>>) {
        this.secrets = value
    }

    @JvmName("sklbimfdltiqicon")
    public suspend fun secrets(vararg values: Output<SecretVolumeItemArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("fwybnnupoxlopggo")
    public suspend fun secrets(values: List<Output<SecretVolumeItemArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Name of storage resource. No need to provide for EmptyDir and Secret.
     */
    @JvmName("ugkwfsstwvnmqism")
    public suspend fun storageName(`value`: Output<String>) {
        this.storageName = value
    }

    /**
     * @param value Storage type for the volume. If not provided, use EmptyDir.
     */
    @JvmName("lhdhxydygrrlbjny")
    public suspend fun storageType(`value`: Output<Either<String, StorageType>>) {
        this.storageType = value
    }

    /**
     * @param value Mount options used while mounting the AzureFile. Must be a comma-separated string.
     */
    @JvmName("svpeocllgiiresun")
    public suspend fun mountOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param value Volume name.
     */
    @JvmName("fbggvdibynbhpygf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("ijmbmqethyuecbnv")
    public suspend fun secrets(`value`: List<SecretVolumeItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("dxfrnruwgagmjwkv")
    public suspend fun secrets(argument: List<suspend SecretVolumeItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecretVolumeItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("vffhixhygmftcgyi")
    public suspend fun secrets(vararg argument: suspend SecretVolumeItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecretVolumeItemArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("xxwlawrdviljiwmr")
    public suspend fun secrets(argument: suspend SecretVolumeItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretVolumeItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values List of secrets to be added in volume. If no secrets are provided, all secrets in collection will be added to volume.
     */
    @JvmName("wdensdquuehqwhgj")
    public suspend fun secrets(vararg values: SecretVolumeItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Name of storage resource. No need to provide for EmptyDir and Secret.
     */
    @JvmName("yrfkbytdynbqaock")
    public suspend fun storageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageName = mapped
    }

    /**
     * @param value Storage type for the volume. If not provided, use EmptyDir.
     */
    @JvmName("rajtsqfkixhamlbg")
    public suspend fun storageType(`value`: Either<String, StorageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value Storage type for the volume. If not provided, use EmptyDir.
     */
    @JvmName("ohfsngbuawguughb")
    public fun storageType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value Storage type for the volume. If not provided, use EmptyDir.
     */
    @JvmName("gxjmvynqprbeodbx")
    public fun storageType(`value`: StorageType) {
        val toBeMapped = Either.ofRight<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        mountOptions = mountOptions,
        name = name,
        secrets = secrets,
        storageName = storageName,
        storageType = storageType,
    )
}
