@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration of application logs
 * @property destination Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'
 * @property logAnalyticsConfiguration Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
 */
public data class AppLogsConfigurationResponse(
    public val destination: String? = null,
    public val logAnalyticsConfiguration: LogAnalyticsConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AppLogsConfigurationResponse):
            AppLogsConfigurationResponse = AppLogsConfigurationResponse(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            logAnalyticsConfiguration = javaType.logAnalyticsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.LogAnalyticsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
