@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
 * @property failureThreshold Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
 * @property httpGet HTTPGet specifies the http request to perform.
 * @property initialDelaySeconds Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
 * @property periodSeconds How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
 * @property successThreshold Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
 * @property tcpSocket TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
 * @property terminationGracePeriodSeconds Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
 * @property timeoutSeconds Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
 * @property type The type of probe.
 */
public data class ContainerAppProbeResponse(
    public val failureThreshold: Int? = null,
    public val httpGet: ContainerAppProbeResponseHttpGet? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val successThreshold: Int? = null,
    public val tcpSocket: ContainerAppProbeResponseTcpSocket? = null,
    public val terminationGracePeriodSeconds: Double? = null,
    public val timeoutSeconds: Int? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ContainerAppProbeResponse):
            ContainerAppProbeResponse = ContainerAppProbeResponse(
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            httpGet = javaType.httpGet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ContainerAppProbeResponseHttpGet.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            tcpSocket = javaType.tcpSocket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ContainerAppProbeResponseTcpSocket.Companion.toKotlin(args0)
                })
            }).orElse(null),
            terminationGracePeriodSeconds = javaType.terminationGracePeriodSeconds().map({ args0 ->
                args0
            }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
