@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Dapr Component Resiliency Policy HTTP Retry Policy Configuration.
 * @property maxRetries The optional maximum number of retries
 * @property retryBackOff The optional retry backoff configuration
 */
public data class DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse(
    public val maxRetries: Int? = null,
    public val retryBackOff: DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse):
            DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse =
            DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse(
                maxRetries = javaType.maxRetries().map({ args0 -> args0 }).orElse(null),
                retryBackOff = javaType.retryBackOff().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyHttpRetryBackOffConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
