@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Dapr PubSub Event Subscription.
 * @property bulkSubscribe Bulk subscription options
 * @property deadLetterTopic Deadletter topic name
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadata Subscription metadata
 * @property name The name of the resource
 * @property pubsubName Dapr PubSub component name
 * @property routes Subscription routes
 * @property scopes Application scopes to restrict the subscription to specific apps.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property topic Topic name
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDaprSubscriptionResult(
    public val bulkSubscribe: DaprSubscriptionBulkSubscribeOptionsResponse? = null,
    public val deadLetterTopic: String? = null,
    public val id: String,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val pubsubName: String? = null,
    public val routes: DaprSubscriptionRoutesResponse? = null,
    public val scopes: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val topic: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetDaprSubscriptionResult):
            GetDaprSubscriptionResult = GetDaprSubscriptionResult(
            bulkSubscribe = javaType.bulkSubscribe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionBulkSubscribeOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deadLetterTopic = javaType.deadLetterTopic().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            pubsubName = javaType.pubsubName().map({ args0 -> args0 }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprSubscriptionRoutesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scopes = javaType.scopes().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
