@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the GitHub provider.
 * @property enabled <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow.
 * @property registration The configuration settings of the app registration for the GitHub provider.
 */
public data class GitHubResponse(
    public val enabled: Boolean? = null,
    public val login: LoginScopesResponse? = null,
    public val registration: ClientRegistrationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GitHubResponse): GitHubResponse =
            GitHubResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                login = javaType.login().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.LoginScopesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                registration = javaType.registration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.ClientRegistrationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
