@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App Ingress configuration.
 * @property allowInsecure Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
 * @property clientCertificateMode Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
 * @property corsPolicy CORS policy for container app
 * @property customDomains custom domain bindings for Container Apps' hostnames.
 * @property exposedPort Exposed Port in containers for TCP traffic from ingress
 * @property external Bool indicating if app exposes an external http endpoint
 * @property fqdn Hostname.
 * @property ipSecurityRestrictions Rules to restrict incoming IP address.
 * @property targetPort Target Port in containers for traffic from ingress
 * @property traffic Traffic weights for app's revisions
 * @property transport Ingress transport protocol
 */
public data class IngressResponse(
    public val allowInsecure: Boolean? = null,
    public val clientCertificateMode: String? = null,
    public val corsPolicy: CorsPolicyResponse? = null,
    public val customDomains: List<CustomDomainResponse>? = null,
    public val exposedPort: Int? = null,
    public val `external`: Boolean? = null,
    public val fqdn: String,
    public val ipSecurityRestrictions: List<IpSecurityRestrictionRuleResponse>? = null,
    public val targetPort: Int? = null,
    public val traffic: List<TrafficWeightResponse>? = null,
    public val transport: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.IngressResponse):
            IngressResponse = IngressResponse(
            allowInsecure = javaType.allowInsecure().map({ args0 -> args0 }).orElse(null),
            clientCertificateMode = javaType.clientCertificateMode().map({ args0 -> args0 }).orElse(null),
            corsPolicy = javaType.corsPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.CorsPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customDomains = javaType.customDomains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.CustomDomainResponse.Companion.toKotlin(args0)
                })
            }),
            exposedPort = javaType.exposedPort().map({ args0 -> args0 }).orElse(null),
            `external` = javaType.`external`().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            ipSecurityRestrictions = javaType.ipSecurityRestrictions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.IpSecurityRestrictionRuleResponse.Companion.toKotlin(args0)
                })
            }),
            targetPort = javaType.targetPort().map({ args0 -> args0 }).orElse(null),
            traffic = javaType.traffic().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TrafficWeightResponse.Companion.toKotlin(args0)
                })
            }),
            transport = javaType.transport().map({ args0 -> args0 }).orElse(null),
        )
    }
}
