@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Non versioned Container Apps Job configuration properties
 * @property eventTriggerConfig Trigger configuration of an event driven job.
 * @property manualTriggerConfig Manual trigger configuration for a single execution job. Properties replicaCompletionCount and parallelism would be set to 1 by default
 * @property registries Collection of private container registry credentials used by a Container apps job
 * @property replicaRetryLimit Maximum number of retries before failing the job.
 * @property replicaTimeout Maximum number of seconds a replica is allowed to run.
 * @property scheduleTriggerConfig Cron formatted repeating trigger schedule ("* * * * *") for cronjobs. Properties completions and parallelism would be set to 1 by default
 * @property secrets Collection of secrets used by a Container Apps Job
 * @property triggerType Trigger type of the job
 */
public data class JobConfigurationResponse(
    public val eventTriggerConfig: JobConfigurationResponseEventTriggerConfig? = null,
    public val manualTriggerConfig: JobConfigurationResponseManualTriggerConfig? = null,
    public val registries: List<RegistryCredentialsResponse>? = null,
    public val replicaRetryLimit: Int? = null,
    public val replicaTimeout: Int,
    public val scheduleTriggerConfig: JobConfigurationResponseScheduleTriggerConfig? = null,
    public val secrets: List<SecretResponse>? = null,
    public val triggerType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobConfigurationResponse):
            JobConfigurationResponse = JobConfigurationResponse(
            eventTriggerConfig = javaType.eventTriggerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponseEventTriggerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            manualTriggerConfig = javaType.manualTriggerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponseManualTriggerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            registries = javaType.registries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.RegistryCredentialsResponse.Companion.toKotlin(args0)
                })
            }),
            replicaRetryLimit = javaType.replicaRetryLimit().map({ args0 -> args0 }).orElse(null),
            replicaTimeout = javaType.replicaTimeout(),
            scheduleTriggerConfig = javaType.scheduleTriggerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponseScheduleTriggerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.SecretResponse.Companion.toKotlin(args0)
                })
            }),
            triggerType = javaType.triggerType(),
        )
    }
}
