@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Scaling configurations for event driven jobs.
 * @property maxExecutions Maximum number of job executions that are created for a trigger, default 100.
 * @property minExecutions Minimum number of job executions that are created for a trigger, default 0
 * @property pollingInterval Interval to check each event source in seconds. Defaults to 30s
 * @property rules Scaling rules.
 */
public data class JobScaleResponse(
    public val maxExecutions: Int? = null,
    public val minExecutions: Int? = null,
    public val pollingInterval: Int? = null,
    public val rules: List<JobScaleRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobScaleResponse):
            JobScaleResponse = JobScaleResponse(
            maxExecutions = javaType.maxExecutions().map({ args0 -> args0 }).orElse(null),
            minExecutions = javaType.minExecutions().map({ args0 -> args0 }).orElse(null),
            pollingInterval = javaType.pollingInterval().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.JobScaleRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
