@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Container Apps Job versioned application definition. Defines the desired state of an immutable revision. Any changes to this section Will result in a new revision being created
 * @property containers List of container definitions for the Container App.
 * @property initContainers List of specialized containers that run before app containers.
 * @property volumes List of volume definitions for the Container App.
 */
public data class JobTemplateResponse(
    public val containers: List<ContainerResponse>? = null,
    public val initContainers: List<InitContainerResponse>? = null,
    public val volumes: List<VolumeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JobTemplateResponse):
            JobTemplateResponse = JobTemplateResponse(
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ContainerResponse.Companion.toKotlin(args0)
                })
            }),
            initContainers = javaType.initContainers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.InitContainerResponse.Companion.toKotlin(args0)
                })
            }),
            volumes = javaType.volumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.VolumeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
