@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
 * @property allowedExternalRedirectUrls External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
 * This is an advanced setting typically only needed by Windows Store application backends.
 * Note that URLs within the current domain are always implicitly allowed.
 * @property cookieExpiration The configuration settings of the session cookie's expiration.
 * @property nonce The configuration settings of the nonce used in the login flow.
 * @property preserveUrlFragmentsForLogins <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
 * @property routes The routes that specify the endpoints used for login and logout requests.
 */
public data class LoginResponse(
    public val allowedExternalRedirectUrls: List<String>? = null,
    public val cookieExpiration: CookieExpirationResponse? = null,
    public val nonce: NonceResponse? = null,
    public val preserveUrlFragmentsForLogins: Boolean? = null,
    public val routes: LoginRoutesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.LoginResponse): LoginResponse =
            LoginResponse(
                allowedExternalRedirectUrls = javaType.allowedExternalRedirectUrls().map({ args0 -> args0 }),
                cookieExpiration = javaType.cookieExpiration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.CookieExpirationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                nonce = javaType.nonce().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.NonceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                preserveUrlFragmentsForLogins = javaType.preserveUrlFragmentsForLogins().map({ args0 ->
                    args0
                }).orElse(null),
                routes = javaType.routes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.LoginRoutesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
