@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the endpoints used for the custom Open ID Connect provider.
 * @property authorizationEndpoint The endpoint to be used to make an authorization request.
 * @property certificationUri The endpoint that provides the keys necessary to validate the token.
 * @property issuer The endpoint that issues the token.
 * @property tokenEndpoint The endpoint to be used to request a token.
 * @property wellKnownOpenIdConfiguration The endpoint that contains all the configuration endpoints for the provider.
 */
public data class OpenIdConnectConfigResponse(
    public val authorizationEndpoint: String? = null,
    public val certificationUri: String? = null,
    public val issuer: String? = null,
    public val tokenEndpoint: String? = null,
    public val wellKnownOpenIdConfiguration: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.OpenIdConnectConfigResponse):
            OpenIdConnectConfigResponse = OpenIdConnectConfigResponse(
            authorizationEndpoint = javaType.authorizationEndpoint().map({ args0 -> args0 }).orElse(null),
            certificationUri = javaType.certificationUri().map({ args0 -> args0 }).orElse(null),
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint().map({ args0 -> args0 }).orElse(null),
            wellKnownOpenIdConfiguration = javaType.wellKnownOpenIdConfiguration().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
