@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Auth Secrets for Scale Rule
 * @property secretRef Name of the secret from which to pull the auth params.
 * @property triggerParameter Trigger Parameter that uses the secret
 */
public data class ScaleRuleAuthResponse(
    public val secretRef: String? = null,
    public val triggerParameter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ScaleRuleAuthResponse):
            ScaleRuleAuthResponse = ScaleRuleAuthResponse(
            secretRef = javaType.secretRef().map({ args0 -> args0 }).orElse(null),
            triggerParameter = javaType.triggerParameter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
