@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Policy that defines tcp request retry conditions
 * @property maxConnectAttempts Maximum number of attempts to connect to the tcp service
 */
public data class TcpRetryPolicyResponse(
    public val maxConnectAttempts: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.TcpRetryPolicyResponse):
            TcpRetryPolicyResponse = TcpRetryPolicyResponse(
            maxConnectAttempts = javaType.maxConnectAttempts().map({ args0 -> args0 }).orElse(null),
        )
    }
}
