@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The configuration settings of the Twitter provider.
 * @property enabled <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property registration The configuration settings of the app registration for the Twitter provider.
 */
public data class TwitterResponse(
    public val enabled: Boolean? = null,
    public val registration: TwitterRegistrationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.TwitterResponse):
            TwitterResponse = TwitterResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            registration = javaType.registration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.TwitterRegistrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
