@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The overview of the compliance result for one report.
 * @property failedCount The count of all failed full automation control.
 * @property manualCount The count of all manual control.
 * @property passedCount The count of all passed full automation control.
 */
public data class OverviewStatusResponse(
    public val failedCount: Int? = null,
    public val manualCount: Int? = null,
    public val passedCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appcomplianceautomation.outputs.OverviewStatusResponse):
            OverviewStatusResponse = OverviewStatusResponse(
            failedCount = javaType.failedCount().map({ args0 -> args0 }).orElse(null),
            manualCount = javaType.manualCount().map({ args0 -> args0 }).orElse(null),
            passedCount = javaType.passedCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
