@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The replica resource.
 * @property endpoint The URI of the replica where the replica API will be available.
 * @property id The resource ID.
 * @property location The location of the replica.
 * @property name The name of the replica.
 * @property provisioningState The provisioning state of the replica.
 * @property systemData Resource system metadata.
 * @property type The type of the resource.
 */
public data class GetReplicaResult(
    public val endpoint: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.GetReplicaResult):
            GetReplicaResult = GetReplicaResult(
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
