@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.AppplatformFunctions.getApiPortalCustomDomainPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getApiPortalPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getApmPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getAppPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getAppResourceUploadUrlPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getApplicationAcceleratorPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getApplicationLiveViewPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBindingPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildServiceAgentPoolPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildServiceBuildPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildServiceBuildResultLogPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildServiceBuilderPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildServiceResourceUploadUrlPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getBuildpackBindingPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getCertificatePlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getConfigServerPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getConfigurationServicePlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getContainerRegistryPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getCustomDomainPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getCustomizedAcceleratorPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getDeploymentLogFileUrlPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getDeploymentPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getDeploymentRemoteDebuggingConfigPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getDevToolPortalPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getGatewayCustomDomainPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getGatewayPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getGatewayRouteConfigPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getMonitoringSettingPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getServicePlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getServiceRegistryPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.getStoragePlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.listApmSecretKeysPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.listBuildServiceBuilderDeploymentsPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.listServiceGloballyEnabledApmsPlain
import com.pulumi.azurenative.appplatform.AppplatformFunctions.listServiceTestKeysPlain
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApiPortalCustomDomainPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApiPortalCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApiPortalPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApiPortalPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApmPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApmPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetAppPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetAppPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetAppResourceUploadUrlPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetAppResourceUploadUrlPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApplicationAcceleratorPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApplicationAcceleratorPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApplicationLiveViewPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetApplicationLiveViewPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBindingPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBindingPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceAgentPoolPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceAgentPoolPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuildPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuildPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuildResultLogPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuildResultLogPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuilderPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceBuilderPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceResourceUploadUrlPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildServiceResourceUploadUrlPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildpackBindingPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetBuildpackBindingPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetConfigServerPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetConfigServerPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetConfigurationServicePlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetConfigurationServicePlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetContainerRegistryPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetContainerRegistryPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCustomDomainPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCustomizedAcceleratorPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetCustomizedAcceleratorPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentLogFileUrlPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentLogFileUrlPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentRemoteDebuggingConfigPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDeploymentRemoteDebuggingConfigPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDevToolPortalPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetDevToolPortalPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayCustomDomainPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayCustomDomainPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayRouteConfigPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetGatewayRouteConfigPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetMonitoringSettingPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetMonitoringSettingPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetServiceRegistryPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetServiceRegistryPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetStoragePlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.GetStoragePlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListApmSecretKeysPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListApmSecretKeysPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListBuildServiceBuilderDeploymentsPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListBuildServiceBuilderDeploymentsPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListServiceGloballyEnabledApmsPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListServiceGloballyEnabledApmsPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListServiceTestKeysPlainArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ListServiceTestKeysPlainArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApiPortalCustomDomainResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApiPortalResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApmResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetAppResourceUploadUrlResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetAppResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApplicationAcceleratorResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApplicationLiveViewResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBindingResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceAgentPoolResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuildResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuildResultLogResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuilderResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceResourceUploadUrlResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildpackBindingResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCertificateResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetConfigServerResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetConfigurationServiceResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetContainerRegistryResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCustomDomainResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCustomizedAcceleratorResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentLogFileUrlResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentRemoteDebuggingConfigResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDevToolPortalResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayCustomDomainResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayRouteConfigResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetMonitoringSettingResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetServiceRegistryResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetStorageResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListApmSecretKeysResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListBuildServiceBuilderDeploymentsResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListServiceGloballyEnabledApmsResult
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListServiceTestKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApiPortalCustomDomainResult.Companion.toKotlin as getApiPortalCustomDomainResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApiPortalResult.Companion.toKotlin as getApiPortalResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApmResult.Companion.toKotlin as getApmResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetAppResourceUploadUrlResult.Companion.toKotlin as getAppResourceUploadUrlResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetAppResult.Companion.toKotlin as getAppResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApplicationAcceleratorResult.Companion.toKotlin as getApplicationAcceleratorResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetApplicationLiveViewResult.Companion.toKotlin as getApplicationLiveViewResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBindingResult.Companion.toKotlin as getBindingResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceAgentPoolResult.Companion.toKotlin as getBuildServiceAgentPoolResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuildResult.Companion.toKotlin as getBuildServiceBuildResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuildResultLogResult.Companion.toKotlin as getBuildServiceBuildResultLogResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceBuilderResult.Companion.toKotlin as getBuildServiceBuilderResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildServiceResourceUploadUrlResult.Companion.toKotlin as getBuildServiceResourceUploadUrlResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetBuildpackBindingResult.Companion.toKotlin as getBuildpackBindingResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetConfigServerResult.Companion.toKotlin as getConfigServerResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetConfigurationServiceResult.Companion.toKotlin as getConfigurationServiceResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetContainerRegistryResult.Companion.toKotlin as getContainerRegistryResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCustomDomainResult.Companion.toKotlin as getCustomDomainResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetCustomizedAcceleratorResult.Companion.toKotlin as getCustomizedAcceleratorResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentLogFileUrlResult.Companion.toKotlin as getDeploymentLogFileUrlResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentRemoteDebuggingConfigResult.Companion.toKotlin as getDeploymentRemoteDebuggingConfigResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDeploymentResult.Companion.toKotlin as getDeploymentResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetDevToolPortalResult.Companion.toKotlin as getDevToolPortalResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayCustomDomainResult.Companion.toKotlin as getGatewayCustomDomainResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayResult.Companion.toKotlin as getGatewayResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetGatewayRouteConfigResult.Companion.toKotlin as getGatewayRouteConfigResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetMonitoringSettingResult.Companion.toKotlin as getMonitoringSettingResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetServiceRegistryResult.Companion.toKotlin as getServiceRegistryResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.GetStorageResult.Companion.toKotlin as getStorageResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListApmSecretKeysResult.Companion.toKotlin as listApmSecretKeysResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListBuildServiceBuilderDeploymentsResult.Companion.toKotlin as listBuildServiceBuilderDeploymentsResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListServiceGloballyEnabledApmsResult.Companion.toKotlin as listServiceGloballyEnabledApmsResultToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.ListServiceTestKeysResult.Companion.toKotlin as listServiceTestKeysResultToKotlin

public object AppplatformFunctions {
    /**
     * Get the API portal and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return API portal resource
     */
    public suspend fun getApiPortal(argument: GetApiPortalPlainArgs): GetApiPortalResult =
        getApiPortalResultToKotlin(getApiPortalPlain(argument.toJava()).await())

    /**
     * @see [getApiPortal].
     * @param apiPortalName The name of API portal.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return API portal resource
     */
    public suspend fun getApiPortal(
        apiPortalName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiPortalResult {
        val argument = GetApiPortalPlainArgs(
            apiPortalName = apiPortalName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiPortalResultToKotlin(getApiPortalPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiPortal].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetApiPortalPlainArgs].
     * @return API portal resource
     */
    public suspend fun getApiPortal(argument: suspend GetApiPortalPlainArgsBuilder.() -> Unit):
        GetApiPortalResult {
        val builder = GetApiPortalPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiPortalResultToKotlin(getApiPortalPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the API portal custom domain.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Custom domain of the API portal
     */
    public suspend fun getApiPortalCustomDomain(argument: GetApiPortalCustomDomainPlainArgs):
        GetApiPortalCustomDomainResult =
        getApiPortalCustomDomainResultToKotlin(getApiPortalCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getApiPortalCustomDomain].
     * @param apiPortalName The name of API portal.
     * @param domainName The name of the API portal custom domain.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Custom domain of the API portal
     */
    public suspend fun getApiPortalCustomDomain(
        apiPortalName: String,
        domainName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApiPortalCustomDomainResult {
        val argument = GetApiPortalCustomDomainPlainArgs(
            apiPortalName = apiPortalName,
            domainName = domainName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApiPortalCustomDomainResultToKotlin(getApiPortalCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getApiPortalCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetApiPortalCustomDomainPlainArgs].
     * @return Custom domain of the API portal
     */
    public suspend
    fun getApiPortalCustomDomain(argument: suspend GetApiPortalCustomDomainPlainArgsBuilder.() -> Unit):
        GetApiPortalCustomDomainResult {
        val builder = GetApiPortalCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApiPortalCustomDomainResultToKotlin(getApiPortalCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the APM by name.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return APM Resource object
     */
    public suspend fun getApm(argument: GetApmPlainArgs): GetApmResult =
        getApmResultToKotlin(getApmPlain(argument.toJava()).await())

    /**
     * @see [getApm].
     * @param apmName The name of the APM
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return APM Resource object
     */
    public suspend fun getApm(
        apmName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApmResult {
        val argument = GetApmPlainArgs(
            apmName = apmName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApmResultToKotlin(getApmPlain(argument.toJava()).await())
    }

    /**
     * @see [getApm].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetApmPlainArgs].
     * @return APM Resource object
     */
    public suspend fun getApm(argument: suspend GetApmPlainArgsBuilder.() -> Unit): GetApmResult {
        val builder = GetApmPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApmResultToKotlin(getApmPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an App and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return App resource payload
     */
    public suspend fun getApp(argument: GetAppPlainArgs): GetAppResult =
        getAppResultToKotlin(getAppPlain(argument.toJava()).await())

    /**
     * @see [getApp].
     * @param appName The name of the App resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param syncStatus Indicates whether sync status
     * @return App resource payload
     */
    public suspend fun getApp(
        appName: String,
        resourceGroupName: String,
        serviceName: String,
        syncStatus: String? = null,
    ): GetAppResult {
        val argument = GetAppPlainArgs(
            appName = appName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            syncStatus = syncStatus,
        )
        return getAppResultToKotlin(getAppPlain(argument.toJava()).await())
    }

    /**
     * @see [getApp].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetAppPlainArgs].
     * @return App resource payload
     */
    public suspend fun getApp(argument: suspend GetAppPlainArgsBuilder.() -> Unit): GetAppResult {
        val builder = GetAppPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppResultToKotlin(getAppPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an resource upload URL for an App, which may be artifacts or source archive.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Resource upload definition payload
     */
    public suspend fun getAppResourceUploadUrl(argument: GetAppResourceUploadUrlPlainArgs):
        GetAppResourceUploadUrlResult =
        getAppResourceUploadUrlResultToKotlin(getAppResourceUploadUrlPlain(argument.toJava()).await())

    /**
     * @see [getAppResourceUploadUrl].
     * @param appName The name of the App resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Resource upload definition payload
     */
    public suspend fun getAppResourceUploadUrl(
        appName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetAppResourceUploadUrlResult {
        val argument = GetAppResourceUploadUrlPlainArgs(
            appName = appName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getAppResourceUploadUrlResultToKotlin(getAppResourceUploadUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getAppResourceUploadUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetAppResourceUploadUrlPlainArgs].
     * @return Resource upload definition payload
     */
    public suspend
    fun getAppResourceUploadUrl(argument: suspend GetAppResourceUploadUrlPlainArgsBuilder.() -> Unit):
        GetAppResourceUploadUrlResult {
        val builder = GetAppResourceUploadUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppResourceUploadUrlResultToKotlin(getAppResourceUploadUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the application accelerator.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Application accelerator resource
     */
    public suspend fun getApplicationAccelerator(argument: GetApplicationAcceleratorPlainArgs):
        GetApplicationAcceleratorResult =
        getApplicationAcceleratorResultToKotlin(getApplicationAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getApplicationAccelerator].
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Application accelerator resource
     */
    public suspend fun getApplicationAccelerator(
        applicationAcceleratorName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApplicationAcceleratorResult {
        val argument = GetApplicationAcceleratorPlainArgs(
            applicationAcceleratorName = applicationAcceleratorName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApplicationAcceleratorResultToKotlin(getApplicationAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetApplicationAcceleratorPlainArgs].
     * @return Application accelerator resource
     */
    public suspend
    fun getApplicationAccelerator(argument: suspend GetApplicationAcceleratorPlainArgsBuilder.() -> Unit):
        GetApplicationAcceleratorResult {
        val builder = GetApplicationAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationAcceleratorResultToKotlin(getApplicationAcceleratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Application Live  and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Application Live View resource
     */
    public suspend fun getApplicationLiveView(argument: GetApplicationLiveViewPlainArgs):
        GetApplicationLiveViewResult =
        getApplicationLiveViewResultToKotlin(getApplicationLiveViewPlain(argument.toJava()).await())

    /**
     * @see [getApplicationLiveView].
     * @param applicationLiveViewName The name of Application Live View.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Application Live View resource
     */
    public suspend fun getApplicationLiveView(
        applicationLiveViewName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetApplicationLiveViewResult {
        val argument = GetApplicationLiveViewPlainArgs(
            applicationLiveViewName = applicationLiveViewName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getApplicationLiveViewResultToKotlin(getApplicationLiveViewPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationLiveView].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetApplicationLiveViewPlainArgs].
     * @return Application Live View resource
     */
    public suspend
    fun getApplicationLiveView(argument: suspend GetApplicationLiveViewPlainArgsBuilder.() -> Unit):
        GetApplicationLiveViewResult {
        val builder = GetApplicationLiveViewPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationLiveViewResultToKotlin(getApplicationLiveViewPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Binding and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Binding resource payload
     */
    public suspend fun getBinding(argument: GetBindingPlainArgs): GetBindingResult =
        getBindingResultToKotlin(getBindingPlain(argument.toJava()).await())

    /**
     * @see [getBinding].
     * @param appName The name of the App resource.
     * @param bindingName The name of the Binding resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Binding resource payload
     */
    public suspend fun getBinding(
        appName: String,
        bindingName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBindingResult {
        val argument = GetBindingPlainArgs(
            appName = appName,
            bindingName = bindingName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBindingResultToKotlin(getBindingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBinding].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBindingPlainArgs].
     * @return Binding resource payload
     */
    public suspend fun getBinding(argument: suspend GetBindingPlainArgsBuilder.() -> Unit):
        GetBindingResult {
        val builder = GetBindingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBindingResultToKotlin(getBindingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get build service agent pool.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The build service agent pool resource
     */
    public suspend fun getBuildServiceAgentPool(argument: GetBuildServiceAgentPoolPlainArgs):
        GetBuildServiceAgentPoolResult =
        getBuildServiceAgentPoolResultToKotlin(getBuildServiceAgentPoolPlain(argument.toJava()).await())

    /**
     * @see [getBuildServiceAgentPool].
     * @param agentPoolName The name of the build service agent pool resource.
     * @param buildServiceName The name of the build service resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return The build service agent pool resource
     */
    public suspend fun getBuildServiceAgentPool(
        agentPoolName: String,
        buildServiceName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildServiceAgentPoolResult {
        val argument = GetBuildServiceAgentPoolPlainArgs(
            agentPoolName = agentPoolName,
            buildServiceName = buildServiceName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildServiceAgentPoolResultToKotlin(getBuildServiceAgentPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildServiceAgentPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildServiceAgentPoolPlainArgs].
     * @return The build service agent pool resource
     */
    public suspend
    fun getBuildServiceAgentPool(argument: suspend GetBuildServiceAgentPoolPlainArgsBuilder.() -> Unit):
        GetBuildServiceAgentPoolResult {
        val builder = GetBuildServiceAgentPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildServiceAgentPoolResultToKotlin(getBuildServiceAgentPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a KPack build.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Build resource payload
     */
    public suspend fun getBuildServiceBuild(argument: GetBuildServiceBuildPlainArgs):
        GetBuildServiceBuildResult =
        getBuildServiceBuildResultToKotlin(getBuildServiceBuildPlain(argument.toJava()).await())

    /**
     * @see [getBuildServiceBuild].
     * @param buildName The name of the build resource.
     * @param buildServiceName The name of the build service resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Build resource payload
     */
    public suspend fun getBuildServiceBuild(
        buildName: String,
        buildServiceName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildServiceBuildResult {
        val argument = GetBuildServiceBuildPlainArgs(
            buildName = buildName,
            buildServiceName = buildServiceName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildServiceBuildResultToKotlin(getBuildServiceBuildPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildServiceBuild].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildServiceBuildPlainArgs].
     * @return Build resource payload
     */
    public suspend
    fun getBuildServiceBuild(argument: suspend GetBuildServiceBuildPlainArgsBuilder.() -> Unit):
        GetBuildServiceBuildResult {
        val builder = GetBuildServiceBuildPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildServiceBuildResultToKotlin(getBuildServiceBuildPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a KPack build result log download URL.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Build result log resource properties payload
     */
    public suspend
    fun getBuildServiceBuildResultLog(argument: GetBuildServiceBuildResultLogPlainArgs):
        GetBuildServiceBuildResultLogResult =
        getBuildServiceBuildResultLogResultToKotlin(getBuildServiceBuildResultLogPlain(argument.toJava()).await())

    /**
     * @see [getBuildServiceBuildResultLog].
     * @param buildName The name of the build resource.
     * @param buildResultName The name of the build result resource.
     * @param buildServiceName The name of the build service resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Build result log resource properties payload
     */
    public suspend fun getBuildServiceBuildResultLog(
        buildName: String,
        buildResultName: String,
        buildServiceName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildServiceBuildResultLogResult {
        val argument = GetBuildServiceBuildResultLogPlainArgs(
            buildName = buildName,
            buildResultName = buildResultName,
            buildServiceName = buildServiceName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildServiceBuildResultLogResultToKotlin(getBuildServiceBuildResultLogPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildServiceBuildResultLog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildServiceBuildResultLogPlainArgs].
     * @return Build result log resource properties payload
     */
    public suspend
    fun getBuildServiceBuildResultLog(argument: suspend GetBuildServiceBuildResultLogPlainArgsBuilder.() -> Unit):
        GetBuildServiceBuildResultLogResult {
        val builder = GetBuildServiceBuildResultLogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildServiceBuildResultLogResultToKotlin(getBuildServiceBuildResultLogPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a KPack builder.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return KPack Builder resource
     */
    public suspend fun getBuildServiceBuilder(argument: GetBuildServiceBuilderPlainArgs):
        GetBuildServiceBuilderResult =
        getBuildServiceBuilderResultToKotlin(getBuildServiceBuilderPlain(argument.toJava()).await())

    /**
     * @see [getBuildServiceBuilder].
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return KPack Builder resource
     */
    public suspend fun getBuildServiceBuilder(
        buildServiceName: String,
        builderName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildServiceBuilderResult {
        val argument = GetBuildServiceBuilderPlainArgs(
            buildServiceName = buildServiceName,
            builderName = builderName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildServiceBuilderResultToKotlin(getBuildServiceBuilderPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildServiceBuilder].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildServiceBuilderPlainArgs].
     * @return KPack Builder resource
     */
    public suspend
    fun getBuildServiceBuilder(argument: suspend GetBuildServiceBuilderPlainArgsBuilder.() -> Unit):
        GetBuildServiceBuilderResult {
        val builder = GetBuildServiceBuilderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildServiceBuilderResultToKotlin(getBuildServiceBuilderPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an resource upload URL for build service, which may be artifacts or source archive.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Resource upload definition payload
     */
    public suspend
    fun getBuildServiceResourceUploadUrl(argument: GetBuildServiceResourceUploadUrlPlainArgs):
        GetBuildServiceResourceUploadUrlResult =
        getBuildServiceResourceUploadUrlResultToKotlin(getBuildServiceResourceUploadUrlPlain(argument.toJava()).await())

    /**
     * @see [getBuildServiceResourceUploadUrl].
     * @param buildServiceName The name of the build service resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Resource upload definition payload
     */
    public suspend fun getBuildServiceResourceUploadUrl(
        buildServiceName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildServiceResourceUploadUrlResult {
        val argument = GetBuildServiceResourceUploadUrlPlainArgs(
            buildServiceName = buildServiceName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildServiceResourceUploadUrlResultToKotlin(getBuildServiceResourceUploadUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildServiceResourceUploadUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildServiceResourceUploadUrlPlainArgs].
     * @return Resource upload definition payload
     */
    public suspend
    fun getBuildServiceResourceUploadUrl(argument: suspend GetBuildServiceResourceUploadUrlPlainArgsBuilder.() -> Unit):
        GetBuildServiceResourceUploadUrlResult {
        val builder = GetBuildServiceResourceUploadUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildServiceResourceUploadUrlResultToKotlin(getBuildServiceResourceUploadUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a buildpack binding by name.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Buildpack Binding Resource object
     */
    public suspend fun getBuildpackBinding(argument: GetBuildpackBindingPlainArgs):
        GetBuildpackBindingResult =
        getBuildpackBindingResultToKotlin(getBuildpackBindingPlain(argument.toJava()).await())

    /**
     * @see [getBuildpackBinding].
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param buildpackBindingName The name of the Buildpack Binding Name
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Buildpack Binding Resource object
     */
    public suspend fun getBuildpackBinding(
        buildServiceName: String,
        builderName: String,
        buildpackBindingName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetBuildpackBindingResult {
        val argument = GetBuildpackBindingPlainArgs(
            buildServiceName = buildServiceName,
            builderName = builderName,
            buildpackBindingName = buildpackBindingName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getBuildpackBindingResultToKotlin(getBuildpackBindingPlain(argument.toJava()).await())
    }

    /**
     * @see [getBuildpackBinding].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetBuildpackBindingPlainArgs].
     * @return Buildpack Binding Resource object
     */
    public suspend
    fun getBuildpackBinding(argument: suspend GetBuildpackBindingPlainArgsBuilder.() -> Unit):
        GetBuildpackBindingResult {
        val builder = GetBuildpackBindingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBuildpackBindingResultToKotlin(getBuildpackBindingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the certificate resource.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2021-06-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Certificate resource payload.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param certificateName The name of the certificate resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Certificate resource payload.
     */
    public suspend fun getCertificate(
        certificateName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            certificateName = certificateName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return Certificate resource payload.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the config server and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Config Server resource
     */
    public suspend fun getConfigServer(argument: GetConfigServerPlainArgs): GetConfigServerResult =
        getConfigServerResultToKotlin(getConfigServerPlain(argument.toJava()).await())

    /**
     * @see [getConfigServer].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Config Server resource
     */
    public suspend fun getConfigServer(resourceGroupName: String, serviceName: String):
        GetConfigServerResult {
        val argument = GetConfigServerPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getConfigServerResultToKotlin(getConfigServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetConfigServerPlainArgs].
     * @return Config Server resource
     */
    public suspend fun getConfigServer(argument: suspend GetConfigServerPlainArgsBuilder.() -> Unit):
        GetConfigServerResult {
        val builder = GetConfigServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigServerResultToKotlin(getConfigServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Application Configuration Service and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Application Configuration Service resource
     */
    public suspend fun getConfigurationService(argument: GetConfigurationServicePlainArgs):
        GetConfigurationServiceResult =
        getConfigurationServiceResultToKotlin(getConfigurationServicePlain(argument.toJava()).await())

    /**
     * @see [getConfigurationService].
     * @param configurationServiceName The name of Application Configuration Service.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Application Configuration Service resource
     */
    public suspend fun getConfigurationService(
        configurationServiceName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetConfigurationServiceResult {
        val argument = GetConfigurationServicePlainArgs(
            configurationServiceName = configurationServiceName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getConfigurationServiceResultToKotlin(getConfigurationServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigurationService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetConfigurationServicePlainArgs].
     * @return Application Configuration Service resource
     */
    public suspend
    fun getConfigurationService(argument: suspend GetConfigurationServicePlainArgsBuilder.() -> Unit):
        GetConfigurationServiceResult {
        val builder = GetConfigurationServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationServiceResultToKotlin(getConfigurationServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the container registries resource.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Container registry resource payload.
     */
    public suspend fun getContainerRegistry(argument: GetContainerRegistryPlainArgs):
        GetContainerRegistryResult =
        getContainerRegistryResultToKotlin(getContainerRegistryPlain(argument.toJava()).await())

    /**
     * @see [getContainerRegistry].
     * @param containerRegistryName The name of the container registry.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Container registry resource payload.
     */
    public suspend fun getContainerRegistry(
        containerRegistryName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetContainerRegistryResult {
        val argument = GetContainerRegistryPlainArgs(
            containerRegistryName = containerRegistryName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getContainerRegistryResultToKotlin(getContainerRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetContainerRegistryPlainArgs].
     * @return Container registry resource payload.
     */
    public suspend
    fun getContainerRegistry(argument: suspend GetContainerRegistryPlainArgsBuilder.() -> Unit):
        GetContainerRegistryResult {
        val builder = GetContainerRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerRegistryResultToKotlin(getContainerRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the custom domain of one lifecycle application.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Custom domain resource payload.
     */
    public suspend fun getCustomDomain(argument: GetCustomDomainPlainArgs): GetCustomDomainResult =
        getCustomDomainResultToKotlin(getCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getCustomDomain].
     * @param appName The name of the App resource.
     * @param domainName The name of the custom domain resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Custom domain resource payload.
     */
    public suspend fun getCustomDomain(
        appName: String,
        domainName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetCustomDomainResult {
        val argument = GetCustomDomainPlainArgs(
            appName = appName,
            domainName = domainName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getCustomDomainResultToKotlin(getCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetCustomDomainPlainArgs].
     * @return Custom domain resource payload.
     */
    public suspend fun getCustomDomain(argument: suspend GetCustomDomainPlainArgsBuilder.() -> Unit):
        GetCustomDomainResult {
        val builder = GetCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomDomainResultToKotlin(getCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the customized accelerator.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Customized accelerator resource
     */
    public suspend fun getCustomizedAccelerator(argument: GetCustomizedAcceleratorPlainArgs):
        GetCustomizedAcceleratorResult =
        getCustomizedAcceleratorResultToKotlin(getCustomizedAcceleratorPlain(argument.toJava()).await())

    /**
     * @see [getCustomizedAccelerator].
     * @param applicationAcceleratorName The name of the application accelerator.
     * @param customizedAcceleratorName The name of the customized accelerator.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Customized accelerator resource
     */
    public suspend fun getCustomizedAccelerator(
        applicationAcceleratorName: String,
        customizedAcceleratorName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetCustomizedAcceleratorResult {
        val argument = GetCustomizedAcceleratorPlainArgs(
            applicationAcceleratorName = applicationAcceleratorName,
            customizedAcceleratorName = customizedAcceleratorName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getCustomizedAcceleratorResultToKotlin(getCustomizedAcceleratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomizedAccelerator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetCustomizedAcceleratorPlainArgs].
     * @return Customized accelerator resource
     */
    public suspend
    fun getCustomizedAccelerator(argument: suspend GetCustomizedAcceleratorPlainArgsBuilder.() -> Unit):
        GetCustomizedAcceleratorResult {
        val builder = GetCustomizedAcceleratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomizedAcceleratorResultToKotlin(getCustomizedAcceleratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Deployment and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Deployment resource payload
     */
    public suspend fun getDeployment(argument: GetDeploymentPlainArgs): GetDeploymentResult =
        getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getDeployment].
     * @param appName The name of the App resource.
     * @param deploymentName The name of the Deployment resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Deployment resource payload
     */
    public suspend fun getDeployment(
        appName: String,
        deploymentName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDeploymentResult {
        val argument = GetDeploymentPlainArgs(
            appName = appName,
            deploymentName = deploymentName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDeploymentResultToKotlin(getDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetDeploymentPlainArgs].
     * @return Deployment resource payload
     */
    public suspend fun getDeployment(argument: suspend GetDeploymentPlainArgsBuilder.() -> Unit):
        GetDeploymentResult {
        val builder = GetDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentResultToKotlin(getDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get deployment log file URL
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Log file URL payload
     */
    public suspend fun getDeploymentLogFileUrl(argument: GetDeploymentLogFileUrlPlainArgs):
        GetDeploymentLogFileUrlResult =
        getDeploymentLogFileUrlResultToKotlin(getDeploymentLogFileUrlPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentLogFileUrl].
     * @param appName The name of the App resource.
     * @param deploymentName The name of the Deployment resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Log file URL payload
     */
    public suspend fun getDeploymentLogFileUrl(
        appName: String,
        deploymentName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDeploymentLogFileUrlResult {
        val argument = GetDeploymentLogFileUrlPlainArgs(
            appName = appName,
            deploymentName = deploymentName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDeploymentLogFileUrlResultToKotlin(getDeploymentLogFileUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentLogFileUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetDeploymentLogFileUrlPlainArgs].
     * @return Log file URL payload
     */
    public suspend
    fun getDeploymentLogFileUrl(argument: suspend GetDeploymentLogFileUrlPlainArgsBuilder.() -> Unit):
        GetDeploymentLogFileUrlResult {
        val builder = GetDeploymentLogFileUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentLogFileUrlResultToKotlin(getDeploymentLogFileUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Get remote debugging config.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Remote debugging config.
     */
    public suspend
    fun getDeploymentRemoteDebuggingConfig(argument: GetDeploymentRemoteDebuggingConfigPlainArgs):
        GetDeploymentRemoteDebuggingConfigResult =
        getDeploymentRemoteDebuggingConfigResultToKotlin(getDeploymentRemoteDebuggingConfigPlain(argument.toJava()).await())

    /**
     * @see [getDeploymentRemoteDebuggingConfig].
     * @param appName The name of the App resource.
     * @param deploymentName The name of the Deployment resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Remote debugging config.
     */
    public suspend fun getDeploymentRemoteDebuggingConfig(
        appName: String,
        deploymentName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDeploymentRemoteDebuggingConfigResult {
        val argument = GetDeploymentRemoteDebuggingConfigPlainArgs(
            appName = appName,
            deploymentName = deploymentName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDeploymentRemoteDebuggingConfigResultToKotlin(getDeploymentRemoteDebuggingConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeploymentRemoteDebuggingConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetDeploymentRemoteDebuggingConfigPlainArgs].
     * @return Remote debugging config.
     */
    public suspend
    fun getDeploymentRemoteDebuggingConfig(argument: suspend GetDeploymentRemoteDebuggingConfigPlainArgsBuilder.() -> Unit):
        GetDeploymentRemoteDebuggingConfigResult {
        val builder = GetDeploymentRemoteDebuggingConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeploymentRemoteDebuggingConfigResultToKotlin(getDeploymentRemoteDebuggingConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Application Live  and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Dev Tool Portal resource
     */
    public suspend fun getDevToolPortal(argument: GetDevToolPortalPlainArgs): GetDevToolPortalResult =
        getDevToolPortalResultToKotlin(getDevToolPortalPlain(argument.toJava()).await())

    /**
     * @see [getDevToolPortal].
     * @param devToolPortalName The name of Dev Tool Portal.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Dev Tool Portal resource
     */
    public suspend fun getDevToolPortal(
        devToolPortalName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetDevToolPortalResult {
        val argument = GetDevToolPortalPlainArgs(
            devToolPortalName = devToolPortalName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getDevToolPortalResultToKotlin(getDevToolPortalPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevToolPortal].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetDevToolPortalPlainArgs].
     * @return Dev Tool Portal resource
     */
    public suspend
    fun getDevToolPortal(argument: suspend GetDevToolPortalPlainArgsBuilder.() -> Unit):
        GetDevToolPortalResult {
        val builder = GetDevToolPortalPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevToolPortalResultToKotlin(getDevToolPortalPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Spring Cloud Gateway and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Spring Cloud Gateway resource
     */
    public suspend fun getGateway(argument: GetGatewayPlainArgs): GetGatewayResult =
        getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())

    /**
     * @see [getGateway].
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Spring Cloud Gateway resource
     */
    public suspend fun getGateway(
        gatewayName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGatewayResult {
        val argument = GetGatewayPlainArgs(
            gatewayName = gatewayName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateway].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetGatewayPlainArgs].
     * @return Spring Cloud Gateway resource
     */
    public suspend fun getGateway(argument: suspend GetGatewayPlainArgsBuilder.() -> Unit):
        GetGatewayResult {
        val builder = GetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayResultToKotlin(getGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Spring Cloud Gateway custom domain.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Custom domain of the Spring Cloud Gateway
     */
    public suspend fun getGatewayCustomDomain(argument: GetGatewayCustomDomainPlainArgs):
        GetGatewayCustomDomainResult =
        getGatewayCustomDomainResultToKotlin(getGatewayCustomDomainPlain(argument.toJava()).await())

    /**
     * @see [getGatewayCustomDomain].
     * @param domainName The name of the Spring Cloud Gateway custom domain.
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Custom domain of the Spring Cloud Gateway
     */
    public suspend fun getGatewayCustomDomain(
        domainName: String,
        gatewayName: String,
        resourceGroupName: String,
        serviceName: String,
    ): GetGatewayCustomDomainResult {
        val argument = GetGatewayCustomDomainPlainArgs(
            domainName = domainName,
            gatewayName = gatewayName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getGatewayCustomDomainResultToKotlin(getGatewayCustomDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayCustomDomain].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetGatewayCustomDomainPlainArgs].
     * @return Custom domain of the Spring Cloud Gateway
     */
    public suspend
    fun getGatewayCustomDomain(argument: suspend GetGatewayCustomDomainPlainArgsBuilder.() -> Unit):
        GetGatewayCustomDomainResult {
        val builder = GetGatewayCustomDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayCustomDomainResultToKotlin(getGatewayCustomDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Spring Cloud Gateway route configs.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Spring Cloud Gateway route config resource
     */
    public suspend fun getGatewayRouteConfig(argument: GetGatewayRouteConfigPlainArgs):
        GetGatewayRouteConfigResult =
        getGatewayRouteConfigResultToKotlin(getGatewayRouteConfigPlain(argument.toJava()).await())

    /**
     * @see [getGatewayRouteConfig].
     * @param gatewayName The name of Spring Cloud Gateway.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param routeConfigName The name of the Spring Cloud Gateway route config.
     * @param serviceName The name of the Service resource.
     * @return Spring Cloud Gateway route config resource
     */
    public suspend fun getGatewayRouteConfig(
        gatewayName: String,
        resourceGroupName: String,
        routeConfigName: String,
        serviceName: String,
    ): GetGatewayRouteConfigResult {
        val argument = GetGatewayRouteConfigPlainArgs(
            gatewayName = gatewayName,
            resourceGroupName = resourceGroupName,
            routeConfigName = routeConfigName,
            serviceName = serviceName,
        )
        return getGatewayRouteConfigResultToKotlin(getGatewayRouteConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayRouteConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetGatewayRouteConfigPlainArgs].
     * @return Spring Cloud Gateway route config resource
     */
    public suspend
    fun getGatewayRouteConfig(argument: suspend GetGatewayRouteConfigPlainArgsBuilder.() -> Unit):
        GetGatewayRouteConfigResult {
        val builder = GetGatewayRouteConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayRouteConfigResultToKotlin(getGatewayRouteConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Monitoring Setting and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Monitoring Setting resource
     */
    public suspend fun getMonitoringSetting(argument: GetMonitoringSettingPlainArgs):
        GetMonitoringSettingResult =
        getMonitoringSettingResultToKotlin(getMonitoringSettingPlain(argument.toJava()).await())

    /**
     * @see [getMonitoringSetting].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Monitoring Setting resource
     */
    public suspend fun getMonitoringSetting(resourceGroupName: String, serviceName: String):
        GetMonitoringSettingResult {
        val argument = GetMonitoringSettingPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getMonitoringSettingResultToKotlin(getMonitoringSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitoringSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetMonitoringSettingPlainArgs].
     * @return Monitoring Setting resource
     */
    public suspend
    fun getMonitoringSetting(argument: suspend GetMonitoringSettingPlainArgsBuilder.() -> Unit):
        GetMonitoringSettingResult {
        val builder = GetMonitoringSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitoringSettingResultToKotlin(getMonitoringSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Service and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Service resource
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Service resource
     */
    public suspend fun getService(resourceGroupName: String, serviceName: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return Service resource
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Service Registry and its properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Service Registry resource
     */
    public suspend fun getServiceRegistry(argument: GetServiceRegistryPlainArgs):
        GetServiceRegistryResult =
        getServiceRegistryResultToKotlin(getServiceRegistryPlain(argument.toJava()).await())

    /**
     * @see [getServiceRegistry].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param serviceRegistryName The name of Service Registry.
     * @return Service Registry resource
     */
    public suspend fun getServiceRegistry(
        resourceGroupName: String,
        serviceName: String,
        serviceRegistryName: String,
    ): GetServiceRegistryResult {
        val argument = GetServiceRegistryPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            serviceRegistryName = serviceRegistryName,
        )
        return getServiceRegistryResultToKotlin(getServiceRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetServiceRegistryPlainArgs].
     * @return Service Registry resource
     */
    public suspend
    fun getServiceRegistry(argument: suspend GetServiceRegistryPlainArgsBuilder.() -> Unit):
        GetServiceRegistryResult {
        val builder = GetServiceRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceRegistryResultToKotlin(getServiceRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the storage resource.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Storage resource payload.
     */
    public suspend fun getStorage(argument: GetStoragePlainArgs): GetStorageResult =
        getStorageResultToKotlin(getStoragePlain(argument.toJava()).await())

    /**
     * @see [getStorage].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @param storageName The name of the storage resource.
     * @return Storage resource payload.
     */
    public suspend fun getStorage(
        resourceGroupName: String,
        serviceName: String,
        storageName: String,
    ): GetStorageResult {
        val argument = GetStoragePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            storageName = storageName,
        )
        return getStorageResultToKotlin(getStoragePlain(argument.toJava()).await())
    }

    /**
     * @see [getStorage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;GetStoragePlainArgs].
     * @return Storage resource payload.
     */
    public suspend fun getStorage(argument: suspend GetStoragePlainArgsBuilder.() -> Unit):
        GetStorageResult {
        val builder = GetStoragePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageResultToKotlin(getStoragePlain(builtArgument.toJava()).await())
    }

    /**
     * List keys of APM sensitive properties.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Keys of APM sensitive properties
     */
    public suspend fun listApmSecretKeys(argument: ListApmSecretKeysPlainArgs):
        ListApmSecretKeysResult =
        listApmSecretKeysResultToKotlin(listApmSecretKeysPlain(argument.toJava()).await())

    /**
     * @see [listApmSecretKeys].
     * @param apmName The name of the APM
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Keys of APM sensitive properties
     */
    public suspend fun listApmSecretKeys(
        apmName: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListApmSecretKeysResult {
        val argument = ListApmSecretKeysPlainArgs(
            apmName = apmName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listApmSecretKeysResultToKotlin(listApmSecretKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listApmSecretKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;ListApmSecretKeysPlainArgs].
     * @return Keys of APM sensitive properties
     */
    public suspend
    fun listApmSecretKeys(argument: suspend ListApmSecretKeysPlainArgsBuilder.() -> Unit):
        ListApmSecretKeysResult {
        val builder = ListApmSecretKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApmSecretKeysResultToKotlin(listApmSecretKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List deployments that are using the builder.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return A list of deployments resource ids.
     */
    public suspend
    fun listBuildServiceBuilderDeployments(argument: ListBuildServiceBuilderDeploymentsPlainArgs):
        ListBuildServiceBuilderDeploymentsResult =
        listBuildServiceBuilderDeploymentsResultToKotlin(listBuildServiceBuilderDeploymentsPlain(argument.toJava()).await())

    /**
     * @see [listBuildServiceBuilderDeployments].
     * @param buildServiceName The name of the build service resource.
     * @param builderName The name of the builder resource.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return A list of deployments resource ids.
     */
    public suspend fun listBuildServiceBuilderDeployments(
        buildServiceName: String,
        builderName: String,
        resourceGroupName: String,
        serviceName: String,
    ): ListBuildServiceBuilderDeploymentsResult {
        val argument = ListBuildServiceBuilderDeploymentsPlainArgs(
            buildServiceName = buildServiceName,
            builderName = builderName,
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listBuildServiceBuilderDeploymentsResultToKotlin(listBuildServiceBuilderDeploymentsPlain(argument.toJava()).await())
    }

    /**
     * @see [listBuildServiceBuilderDeployments].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;ListBuildServiceBuilderDeploymentsPlainArgs].
     * @return A list of deployments resource ids.
     */
    public suspend
    fun listBuildServiceBuilderDeployments(argument: suspend ListBuildServiceBuilderDeploymentsPlainArgsBuilder.() -> Unit):
        ListBuildServiceBuilderDeploymentsResult {
        val builder = ListBuildServiceBuilderDeploymentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBuildServiceBuilderDeploymentsResultToKotlin(listBuildServiceBuilderDeploymentsPlain(builtArgument.toJava()).await())
    }

    /**
     * List globally enabled APMs for a Service.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Globally enabled APMs payload
     */
    public suspend
    fun listServiceGloballyEnabledApms(argument: ListServiceGloballyEnabledApmsPlainArgs):
        ListServiceGloballyEnabledApmsResult =
        listServiceGloballyEnabledApmsResultToKotlin(listServiceGloballyEnabledApmsPlain(argument.toJava()).await())

    /**
     * @see [listServiceGloballyEnabledApms].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Globally enabled APMs payload
     */
    public suspend fun listServiceGloballyEnabledApms(resourceGroupName: String, serviceName: String):
        ListServiceGloballyEnabledApmsResult {
        val argument = ListServiceGloballyEnabledApmsPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listServiceGloballyEnabledApmsResultToKotlin(listServiceGloballyEnabledApmsPlain(argument.toJava()).await())
    }

    /**
     * @see [listServiceGloballyEnabledApms].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;ListServiceGloballyEnabledApmsPlainArgs].
     * @return Globally enabled APMs payload
     */
    public suspend
    fun listServiceGloballyEnabledApms(argument: suspend ListServiceGloballyEnabledApmsPlainArgsBuilder.() -> Unit):
        ListServiceGloballyEnabledApmsResult {
        val builder = ListServiceGloballyEnabledApmsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServiceGloballyEnabledApmsResultToKotlin(listServiceGloballyEnabledApmsPlain(builtArgument.toJava()).await())
    }

    /**
     * List test keys for a Service.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return Test keys payload
     */
    public suspend fun listServiceTestKeys(argument: ListServiceTestKeysPlainArgs):
        ListServiceTestKeysResult =
        listServiceTestKeysResultToKotlin(listServiceTestKeysPlain(argument.toJava()).await())

    /**
     * @see [listServiceTestKeys].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceName The name of the Service resource.
     * @return Test keys payload
     */
    public suspend fun listServiceTestKeys(resourceGroupName: String, serviceName: String):
        ListServiceTestKeysResult {
        val argument = ListServiceTestKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
        )
        return listServiceTestKeysResultToKotlin(listServiceTestKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listServiceTestKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;appplatform&#46;kotlin&#46;inputs&#46;ListServiceTestKeysPlainArgs].
     * @return Test keys payload
     */
    public suspend
    fun listServiceTestKeys(argument: suspend ListServiceTestKeysPlainArgsBuilder.() -> Unit):
        ListServiceTestKeysResult {
        val builder = ListServiceTestKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServiceTestKeysResultToKotlin(listServiceTestKeysPlain(builtArgument.toJava()).await())
    }
}
