@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildServiceAgentPoolPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.BuildServiceAgentPoolPropertiesResponse.Companion.toKotlin as buildServiceAgentPoolPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BuildServiceAgentPool].
 */
@PulumiTagMarker
public class BuildServiceAgentPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BuildServiceAgentPoolArgs = BuildServiceAgentPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BuildServiceAgentPoolArgsBuilder.() -> Unit) {
        val builder = BuildServiceAgentPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BuildServiceAgentPool {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.BuildServiceAgentPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BuildServiceAgentPool(builtJavaResource)
    }
}

/**
 * The build service agent pool resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### BuildServiceAgentPool_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildServiceAgentPool = new AzureNative.AppPlatform.BuildServiceAgentPool("buildServiceAgentPool", new()
 *     {
 *         AgentPoolName = "default",
 *         BuildServiceName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuildServiceAgentPoolPropertiesArgs
 *         {
 *             PoolSize = new AzureNative.AppPlatform.Inputs.BuildServiceAgentPoolSizePropertiesArgs
 *             {
 *                 Name = "S3",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildServiceAgentPool(ctx, "buildServiceAgentPool", &appplatform.BuildServiceAgentPoolArgs{
 * 			AgentPoolName:    pulumi.String("default"),
 * 			BuildServiceName: pulumi.String("default"),
 * 			Properties: appplatform.BuildServiceAgentPoolPropertiesResponse{
 * 				PoolSize: &appplatform.BuildServiceAgentPoolSizePropertiesArgs{
 * 					Name: pulumi.String("S3"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildServiceAgentPool;
 * import com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildServiceAgentPool = new BuildServiceAgentPool("buildServiceAgentPool", BuildServiceAgentPoolArgs.builder()
 *             .agentPoolName("default")
 *             .buildServiceName("default")
 *             .properties(Map.of("poolSize", Map.of("name", "S3")))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildServiceAgentPool default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}
 * ```
 */
public class BuildServiceAgentPool internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.BuildServiceAgentPool,
) : KotlinCustomResource(javaResource, BuildServiceAgentPoolMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * build service agent pool properties
     */
    public val properties: Output<BuildServiceAgentPoolPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                buildServiceAgentPoolPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BuildServiceAgentPoolMapper : ResourceMapper<BuildServiceAgentPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.BuildServiceAgentPool::class == javaResource::class

    override fun map(javaResource: Resource): BuildServiceAgentPool =
        BuildServiceAgentPool(
            javaResource as
                com.pulumi.azurenative.appplatform.BuildServiceAgentPool,
        )
}

/**
 * @see [BuildServiceAgentPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BuildServiceAgentPool].
 */
public suspend fun buildServiceAgentPool(
    name: String,
    block: suspend BuildServiceAgentPoolResourceBuilder.() -> Unit,
): BuildServiceAgentPool {
    val builder = BuildServiceAgentPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BuildServiceAgentPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun buildServiceAgentPool(name: String): BuildServiceAgentPool {
    val builder = BuildServiceAgentPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
