@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.BuildpackBindingArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuildpackBindingPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuildpackBindingPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Buildpack Binding Resource object
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### BuildpackBinding_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildpackBinding = new AzureNative.AppPlatform.BuildpackBinding("buildpackBinding", new()
 *     {
 *         BuildServiceName = "default",
 *         BuilderName = "default",
 *         BuildpackBindingName = "myBuildpackBinding",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuildpackBindingPropertiesArgs
 *         {
 *             BindingType = "ApplicationInsights",
 *             LaunchProperties = new AzureNative.AppPlatform.Inputs.BuildpackBindingLaunchPropertiesArgs
 *             {
 *                 Properties =
 *                 {
 *                     { "abc", "def" },
 *                     { "any-string", "any-string" },
 *                     { "sampling-rate", "12.0" },
 *                 },
 *                 Secrets =
 *                 {
 *                     { "connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX" },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildpackBinding(ctx, "buildpackBinding", &appplatform.BuildpackBindingArgs{
 * 			BuildServiceName:     pulumi.String("default"),
 * 			BuilderName:          pulumi.String("default"),
 * 			BuildpackBindingName: pulumi.String("myBuildpackBinding"),
 * 			Properties: appplatform.BuildpackBindingPropertiesResponse{
 * 				BindingType: pulumi.String("ApplicationInsights"),
 * 				LaunchProperties: &appplatform.BuildpackBindingLaunchPropertiesArgs{
 * 					Properties: pulumi.StringMap{
 * 						"abc":           pulumi.String("def"),
 * 						"any-string":    pulumi.String("any-string"),
 * 						"sampling-rate": pulumi.String("12.0"),
 * 					},
 * 					Secrets: pulumi.StringMap{
 * 						"connection-string": pulumi.String("XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildpackBinding;
 * import com.pulumi.azurenative.appplatform.BuildpackBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildpackBinding = new BuildpackBinding("buildpackBinding", BuildpackBindingArgs.builder()
 *             .buildServiceName("default")
 *             .builderName("default")
 *             .buildpackBindingName("myBuildpackBinding")
 *             .properties(Map.ofEntries(
 *                 Map.entry("bindingType", "ApplicationInsights"),
 *                 Map.entry("launchProperties", Map.ofEntries(
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("abc", "def"),
 *                         Map.entry("any-string", "any-string"),
 *                         Map.entry("sampling-rate", "12.0")
 *                     )),
 *                     Map.entry("secrets", Map.of("connection-string", "XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXX;XXXXXXXXXXXXXXXXX=XXXXXXXXXXXXXXXXXXX"))
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildpackBinding myBuildpackBinding /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builders/{builderName}/buildpackBindings/{buildpackBindingName}
 * ```
 * @property buildServiceName The name of the build service resource.
 * @property builderName The name of the builder resource.
 * @property buildpackBindingName The name of the Buildpack Binding Name
 * @property properties Properties of a buildpack binding
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class BuildpackBindingArgs(
    public val buildServiceName: Output<String>? = null,
    public val builderName: Output<String>? = null,
    public val buildpackBindingName: Output<String>? = null,
    public val properties: Output<BuildpackBindingPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.BuildpackBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.BuildpackBindingArgs =
        com.pulumi.azurenative.appplatform.BuildpackBindingArgs.builder()
            .buildServiceName(buildServiceName?.applyValue({ args0 -> args0 }))
            .builderName(builderName?.applyValue({ args0 -> args0 }))
            .buildpackBindingName(buildpackBindingName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildpackBindingArgs].
 */
@PulumiTagMarker
public class BuildpackBindingArgsBuilder internal constructor() {
    private var buildServiceName: Output<String>? = null

    private var builderName: Output<String>? = null

    private var buildpackBindingName: Output<String>? = null

    private var properties: Output<BuildpackBindingPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("dujjoekvvjbpynyv")
    public suspend fun buildServiceName(`value`: Output<String>) {
        this.buildServiceName = value
    }

    /**
     * @param value The name of the builder resource.
     */
    @JvmName("yhvryyihtfatgycq")
    public suspend fun builderName(`value`: Output<String>) {
        this.builderName = value
    }

    /**
     * @param value The name of the Buildpack Binding Name
     */
    @JvmName("avginfaxulbklfus")
    public suspend fun buildpackBindingName(`value`: Output<String>) {
        this.buildpackBindingName = value
    }

    /**
     * @param value Properties of a buildpack binding
     */
    @JvmName("ejnurkccsifyuhlq")
    public suspend fun properties(`value`: Output<BuildpackBindingPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kmmaprvsywffqkbq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("teyclvyqevqkrqtu")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("cnwvybaotiyroqaf")
    public suspend fun buildServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildServiceName = mapped
    }

    /**
     * @param value The name of the builder resource.
     */
    @JvmName("svrbstghceqvaaal")
    public suspend fun builderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.builderName = mapped
    }

    /**
     * @param value The name of the Buildpack Binding Name
     */
    @JvmName("bwvdxdoquayyrjbi")
    public suspend fun buildpackBindingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildpackBindingName = mapped
    }

    /**
     * @param value Properties of a buildpack binding
     */
    @JvmName("bwkastleuidrdimi")
    public suspend fun properties(`value`: BuildpackBindingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of a buildpack binding
     */
    @JvmName("phvcwcxhqvjnnqxe")
    public suspend
    fun properties(argument: suspend BuildpackBindingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BuildpackBindingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mrryvrugpwlgflfd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("wvknflxgetffkwkr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): BuildpackBindingArgs = BuildpackBindingArgs(
        buildServiceName = buildServiceName,
        builderName = builderName,
        buildpackBindingName = buildpackBindingName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
