@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ConfigServerArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ConfigServerPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ConfigServerPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Config Server resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ConfigServers_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configServer = new AzureNative.AppPlatform.ConfigServer("configServer", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigServerPropertiesArgs
 *         {
 *             ConfigServer = new AzureNative.AppPlatform.Inputs.ConfigServerSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigServerGitPropertyArgs
 *                 {
 *                     Label = "master",
 *                     SearchPaths = new[]
 *                     {
 *                         "/",
 *                     },
 *                     Uri = "https://github.com/fake-user/fake-repository.git",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewConfigServer(ctx, "configServer", &appplatform.ConfigServerArgs{
 * Properties: appplatform.ConfigServerPropertiesResponse{
 * ConfigServer: interface{}{
 * GitProperty: &appplatform.ConfigServerGitPropertyArgs{
 * Label: pulumi.String("master"),
 * SearchPaths: pulumi.StringArray{
 * pulumi.String("/"),
 * },
 * Uri: pulumi.String("https://github.com/fake-user/fake-repository.git"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigServer;
 * import com.pulumi.azurenative.appplatform.ConfigServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configServer = new ConfigServer("configServer", ConfigServerArgs.builder()
 *             .properties(Map.of("configServer", Map.of("gitProperty", Map.ofEntries(
 *                 Map.entry("label", "master"),
 *                 Map.entry("searchPaths", "/"),
 *                 Map.entry("uri", "https://github.com/fake-user/fake-repository.git")
 *             ))))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ### ConfigServers_UpdatePut_Consumption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configServer = new AzureNative.AppPlatform.ConfigServer("configServer", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigServerPropertiesArgs
 *         {
 *             ConfigServer = new AzureNative.AppPlatform.Inputs.ConfigServerSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigServerGitPropertyArgs
 *                 {
 *                     Label = "master",
 *                     SearchPaths = new[]
 *                     {
 *                         "/",
 *                     },
 *                     Uri = "https://github.com/fake-user/fake-repository.git",
 *                 },
 *             },
 *             EnabledState = "Enabled",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewConfigServer(ctx, "configServer", &appplatform.ConfigServerArgs{
 * Properties: appplatform.ConfigServerPropertiesResponse{
 * ConfigServer: interface{}{
 * GitProperty: &appplatform.ConfigServerGitPropertyArgs{
 * Label: pulumi.String("master"),
 * SearchPaths: pulumi.StringArray{
 * pulumi.String("/"),
 * },
 * Uri: pulumi.String("https://github.com/fake-user/fake-repository.git"),
 * },
 * },
 * EnabledState: pulumi.String("Enabled"),
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigServer;
 * import com.pulumi.azurenative.appplatform.ConfigServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configServer = new ConfigServer("configServer", ConfigServerArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("configServer", Map.of("gitProperty", Map.ofEntries(
 *                     Map.entry("label", "master"),
 *                     Map.entry("searchPaths", "/"),
 *                     Map.entry("uri", "https://github.com/fake-user/fake-repository.git")
 *                 ))),
 *                 Map.entry("enabledState", "Enabled")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ConfigServer default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default
 * ```
 * @property properties Properties of the Config Server resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class ConfigServerArgs(
    public val properties: Output<ConfigServerPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ConfigServerArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ConfigServerArgs =
        com.pulumi.azurenative.appplatform.ConfigServerArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigServerArgs].
 */
@PulumiTagMarker
public class ConfigServerArgsBuilder internal constructor() {
    private var properties: Output<ConfigServerPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Properties of the Config Server resource
     */
    @JvmName("gokcknyinnsoncts")
    public suspend fun properties(`value`: Output<ConfigServerPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("unainqbkjsornpwq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("anfnvehnffnelshf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Properties of the Config Server resource
     */
    @JvmName("bprpxrttlmqfwaao")
    public suspend fun properties(`value`: ConfigServerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Config Server resource
     */
    @JvmName("cesmbjyvttjmsyrl")
    public suspend fun properties(argument: suspend ConfigServerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigServerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("evgaptmdnklnkvue")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("rcxrdoprervavngj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ConfigServerArgs = ConfigServerArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
