@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigurationServicePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.ConfigurationServicePropertiesResponse.Companion.toKotlin as configurationServicePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ConfigurationService].
 */
@PulumiTagMarker
public class ConfigurationServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationServiceArgs = ConfigurationServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationServiceArgsBuilder.() -> Unit) {
        val builder = ConfigurationServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationService {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.ConfigurationService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationService(builtJavaResource)
    }
}

/**
 * Application Configuration Service resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ConfigurationServices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationService = new AzureNative.AppPlatform.ConfigurationService("configurationService", new()
 *     {
 *         ConfigurationServiceName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.ConfigurationServicePropertiesArgs
 *         {
 *             Settings = new AzureNative.AppPlatform.Inputs.ConfigurationServiceSettingsArgs
 *             {
 *                 GitProperty = new AzureNative.AppPlatform.Inputs.ConfigurationServiceGitPropertyArgs
 *                 {
 *                     Repositories = new[]
 *                     {
 *                         new AzureNative.AppPlatform.Inputs.ConfigurationServiceGitRepositoryArgs
 *                         {
 *                             Label = "master",
 *                             Name = "fake",
 *                             Patterns = new[]
 *                             {
 *                                 "app/dev",
 *                             },
 *                             Uri = "https://github.com/fake-user/fake-repository",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewConfigurationService(ctx, "configurationService", &appplatform.ConfigurationServiceArgs{
 * ConfigurationServiceName: pulumi.String("default"),
 * Properties: appplatform.ConfigurationServicePropertiesResponse{
 * Settings: interface{}{
 * GitProperty: interface{}{
 * Repositories: appplatform.ConfigurationServiceGitRepositoryArray{
 * &appplatform.ConfigurationServiceGitRepositoryArgs{
 * Label: pulumi.String("master"),
 * Name: pulumi.String("fake"),
 * Patterns: pulumi.StringArray{
 * pulumi.String("app/dev"),
 * },
 * Uri: pulumi.String("https://github.com/fake-user/fake-repository"),
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.ConfigurationService;
 * import com.pulumi.azurenative.appplatform.ConfigurationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationService = new ConfigurationService("configurationService", ConfigurationServiceArgs.builder()
 *             .configurationServiceName("default")
 *             .properties(Map.of("settings", Map.of("gitProperty", Map.of("repositories", Map.ofEntries(
 *                 Map.entry("label", "master"),
 *                 Map.entry("name", "fake"),
 *                 Map.entry("patterns", "app/dev"),
 *                 Map.entry("uri", "https://github.com/fake-user/fake-repository")
 *             )))))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:ConfigurationService default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}
 * ```
 */
public class ConfigurationService internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.ConfigurationService,
) : KotlinCustomResource(javaResource, ConfigurationServiceMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Application Configuration Service properties payload
     */
    public val properties: Output<ConfigurationServicePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationServicePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationServiceMapper : ResourceMapper<ConfigurationService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.ConfigurationService::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationService = ConfigurationService(
        javaResource
            as com.pulumi.azurenative.appplatform.ConfigurationService,
    )
}

/**
 * @see [ConfigurationService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationService].
 */
public suspend fun configurationService(
    name: String,
    block: suspend ConfigurationServiceResourceBuilder.() -> Unit,
): ConfigurationService {
    val builder = ConfigurationServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationService(name: String): ConfigurationService {
    val builder = ConfigurationServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
