@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.CustomDomainPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.CustomDomainPropertiesResponse.Companion.toKotlin as customDomainPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CustomDomain].
 */
@PulumiTagMarker
public class CustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDomainArgs = CustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDomainArgsBuilder.() -> Unit) {
        val builder = CustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomDomain {
        val builtJavaResource = com.pulumi.azurenative.appplatform.CustomDomain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomDomain(builtJavaResource)
    }
}

/**
 * Custom domain resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### CustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customDomain = new AzureNative.AppPlatform.CustomDomain("customDomain", new()
 *     {
 *         AppName = "myapp",
 *         DomainName = "mydomain.com",
 *         Properties = new AzureNative.AppPlatform.Inputs.CustomDomainPropertiesArgs
 *         {
 *             CertName = "mycert",
 *             Thumbprint = "934367bf1c97033f877db0f15cb1b586957d3133",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCustomDomain(ctx, "customDomain", &appplatform.CustomDomainArgs{
 * 			AppName:    pulumi.String("myapp"),
 * 			DomainName: pulumi.String("mydomain.com"),
 * 			Properties: &appplatform.CustomDomainPropertiesArgs{
 * 				CertName:   pulumi.String("mycert"),
 * 				Thumbprint: pulumi.String("934367bf1c97033f877db0f15cb1b586957d3133"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.CustomDomain;
 * import com.pulumi.azurenative.appplatform.CustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customDomain = new CustomDomain("customDomain", CustomDomainArgs.builder()
 *             .appName("myapp")
 *             .domainName("mydomain.com")
 *             .properties(Map.ofEntries(
 *                 Map.entry("certName", "mycert"),
 *                 Map.entry("thumbprint", "934367bf1c97033f877db0f15cb1b586957d3133")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:CustomDomain mydomain.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}
 * ```
 */
public class CustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.CustomDomain,
) : KotlinCustomResource(javaResource, CustomDomainMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the custom domain resource.
     */
    public val properties: Output<CustomDomainPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                customDomainPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomDomainMapper : ResourceMapper<CustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.CustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): CustomDomain = CustomDomain(
        javaResource as
            com.pulumi.azurenative.appplatform.CustomDomain,
    )
}

/**
 * @see [CustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDomain].
 */
public suspend fun customDomain(
    name: String,
    block: suspend CustomDomainResourceBuilder.() -> Unit,
): CustomDomain {
    val builder = CustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDomain(name: String): CustomDomain {
    val builder = CustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
