@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalPropertiesResponse.Companion.toKotlin as devToolPortalPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DevToolPortal].
 */
@PulumiTagMarker
public class DevToolPortalResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevToolPortalArgs = DevToolPortalArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevToolPortalArgsBuilder.() -> Unit) {
        val builder = DevToolPortalArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DevToolPortal {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.DevToolPortal(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DevToolPortal(builtJavaResource)
    }
}

/**
 * Dev Tool Portal resource
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### DevToolPortals_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devToolPortal = new AzureNative.AppPlatform.DevToolPortal("devToolPortal", new()
 *     {
 *         DevToolPortalName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.DevToolPortalPropertiesArgs
 *         {
 *             Features = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureSettingsArgs
 *             {
 *                 ApplicationAccelerator = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureDetailArgs
 *                 {
 *                     State = "Enabled",
 *                 },
 *                 ApplicationLiveView = new AzureNative.AppPlatform.Inputs.DevToolPortalFeatureDetailArgs
 *                 {
 *                     State = "Enabled",
 *                 },
 *             },
 *             Public = true,
 *             SsoProperties = new AzureNative.AppPlatform.Inputs.DevToolPortalSsoPropertiesArgs
 *             {
 *                 ClientId = "00000000-0000-0000-0000-000000000000",
 *                 ClientSecret = "xxxxx",
 *                 MetadataUrl = "https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration",
 *                 Scopes = new[]
 *                 {
 *                     "openid",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewDevToolPortal(ctx, "devToolPortal", &appplatform.DevToolPortalArgs{
 * DevToolPortalName: pulumi.String("default"),
 * Properties: appplatform.DevToolPortalPropertiesResponse{
 * Features: interface{}{
 * ApplicationAccelerator: &appplatform.DevToolPortalFeatureDetailArgs{
 * State: pulumi.String("Enabled"),
 * },
 * ApplicationLiveView: &appplatform.DevToolPortalFeatureDetailArgs{
 * State: pulumi.String("Enabled"),
 * },
 * },
 * Public: pulumi.Bool(true),
 * SsoProperties: &appplatform.DevToolPortalSsoPropertiesArgs{
 * ClientId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * ClientSecret: pulumi.String("xxxxx"),
 * MetadataUrl: pulumi.String("https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration"),
 * Scopes: pulumi.StringArray{
 * pulumi.String("openid"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.DevToolPortal;
 * import com.pulumi.azurenative.appplatform.DevToolPortalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devToolPortal = new DevToolPortal("devToolPortal", DevToolPortalArgs.builder()
 *             .devToolPortalName("default")
 *             .properties(Map.ofEntries(
 *                 Map.entry("features", Map.ofEntries(
 *                     Map.entry("applicationAccelerator", Map.of("state", "Enabled")),
 *                     Map.entry("applicationLiveView", Map.of("state", "Enabled"))
 *                 )),
 *                 Map.entry("public", true),
 *                 Map.entry("ssoProperties", Map.ofEntries(
 *                     Map.entry("clientId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("clientSecret", "xxxxx"),
 *                     Map.entry("metadataUrl", "https://login.microsoftonline.com/00000000-0000-0000-0000-000000000000/v2.0/.well-known/openid-configuration"),
 *                     Map.entry("scopes", "openid")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:DevToolPortal default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/DevToolPortals/{devToolPortalName}
 * ```
 */
public class DevToolPortal internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.DevToolPortal,
) : KotlinCustomResource(javaResource, DevToolPortalMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dev Tool Portal properties payload
     */
    public val properties: Output<DevToolPortalPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                devToolPortalPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevToolPortalMapper : ResourceMapper<DevToolPortal> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.DevToolPortal::class == javaResource::class

    override fun map(javaResource: Resource): DevToolPortal = DevToolPortal(
        javaResource as
            com.pulumi.azurenative.appplatform.DevToolPortal,
    )
}

/**
 * @see [DevToolPortal].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevToolPortal].
 */
public suspend fun devToolPortal(
    name: String,
    block: suspend DevToolPortalResourceBuilder.() -> Unit,
): DevToolPortal {
    val builder = DevToolPortalResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevToolPortal].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devToolPortal(name: String): DevToolPortal {
    val builder = DevToolPortalResourceBuilder()
    builder.name(name)
    return builder.build()
}
