@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.MonitoringSettingArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.MonitoringSettingPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.MonitoringSettingPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Monitoring Setting resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### MonitoringSettings_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoringSetting = new AzureNative.AppPlatform.MonitoringSetting("monitoringSetting", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.MonitoringSettingPropertiesArgs
 *         {
 *             AppInsightsInstrumentationKey = "00000000-0000-0000-0000-000000000000",
 *             AppInsightsSamplingRate = 10,
 *             TraceEnabled = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewMonitoringSetting(ctx, "monitoringSetting", &appplatform.MonitoringSettingArgs{
 * 			Properties: &appplatform.MonitoringSettingPropertiesArgs{
 * 				AppInsightsInstrumentationKey: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				AppInsightsSamplingRate:       pulumi.Float64(10),
 * 				TraceEnabled:                  pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.MonitoringSetting;
 * import com.pulumi.azurenative.appplatform.MonitoringSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoringSetting = new MonitoringSetting("monitoringSetting", MonitoringSettingArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("appInsightsInstrumentationKey", "00000000-0000-0000-0000-000000000000"),
 *                 Map.entry("appInsightsSamplingRate", 10),
 *                 Map.entry("traceEnabled", true)
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:MonitoringSetting default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/monitoringSettings/default
 * ```
 * @property properties Properties of the Monitoring Setting resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class MonitoringSettingArgs(
    public val properties: Output<MonitoringSettingPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.MonitoringSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.MonitoringSettingArgs =
        com.pulumi.azurenative.appplatform.MonitoringSettingArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringSettingArgs].
 */
@PulumiTagMarker
public class MonitoringSettingArgsBuilder internal constructor() {
    private var properties: Output<MonitoringSettingPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Properties of the Monitoring Setting resource
     */
    @JvmName("vpxscjbxpyncnbjh")
    public suspend fun properties(`value`: Output<MonitoringSettingPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ioblihpopryauanf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("vojslwfbbyomspxx")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Properties of the Monitoring Setting resource
     */
    @JvmName("efdigvnfcwgwxrby")
    public suspend fun properties(`value`: MonitoringSettingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Monitoring Setting resource
     */
    @JvmName("xbyyhqdqghvndmmj")
    public suspend
    fun properties(argument: suspend MonitoringSettingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringSettingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wehmkfcwveyuonqn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("mckmsjhxokuigrfa")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): MonitoringSettingArgs = MonitoringSettingArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
