@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.ClusterResourcePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.appplatform.kotlin.outputs.ClusterResourcePropertiesResponse.Companion.toKotlin as clusterResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Service resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Services_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_Consumption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             ManagedEnvironmentId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "StandardGen2",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: &appplatform.ClusterResourcePropertiesArgs{
 * 				ManagedEnvironmentId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("StandardGen2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("managedEnvironmentId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment"))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "StandardGen2")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_Enterprise
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             MarketplaceResource = new AzureNative.AppPlatform.Inputs.MarketplaceResourceArgs
 *             {
 *                 Plan = "tanzu-asc-ent-mtr",
 *                 Product = "azure-spring-cloud-vmware-tanzu-2",
 *                 Publisher = "vmware-inc",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: appplatform.ClusterResourcePropertiesResponse{
 * 				MarketplaceResource: &appplatform.MarketplaceResourceArgs{
 * 					Plan:      pulumi.String("tanzu-asc-ent-mtr"),
 * 					Product:   pulumi.String("azure-spring-cloud-vmware-tanzu-2"),
 * 					Publisher: pulumi.String("vmware-inc"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("E0"),
 * 				Tier: pulumi.String("Enterprise"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("marketplaceResource", Map.ofEntries(
 *                 Map.entry("plan", "tanzu-asc-ent-mtr"),
 *                 Map.entry("product", "azure-spring-cloud-vmware-tanzu-2"),
 *                 Map.entry("publisher", "vmware-inc")
 *             )))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "E0"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_VNetInjection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             NetworkProfile = new AzureNative.AppPlatform.Inputs.NetworkProfileArgs
 *             {
 *                 AppNetworkResourceGroup = "my-app-network-rg",
 *                 AppSubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps",
 *                 IngressConfig = new AzureNative.AppPlatform.Inputs.IngressConfigArgs
 *                 {
 *                     ReadTimeoutInSeconds = 300,
 *                 },
 *                 ServiceCidr = "10.8.0.0/16,10.244.0.0/16,10.245.0.1/16",
 *                 ServiceRuntimeNetworkResourceGroup = "my-service-runtime-network-rg",
 *                 ServiceRuntimeSubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime",
 *             },
 *             VnetAddons = new AzureNative.AppPlatform.Inputs.ServiceVNetAddonsArgs
 *             {
 *                 DataPlanePublicEndpoint = true,
 *                 LogStreamPublicEndpoint = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * Location: pulumi.String("eastus"),
 * Properties: appplatform.ClusterResourcePropertiesResponse{
 * NetworkProfile: interface{}{
 * AppNetworkResourceGroup: pulumi.String("my-app-network-rg"),
 * AppSubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps"),
 * IngressConfig: &appplatform.IngressConfigArgs{
 * ReadTimeoutInSeconds: pulumi.Int(300),
 * },
 * ServiceCidr: pulumi.String("10.8.0.0/16,10.244.0.0/16,10.245.0.1/16"),
 * ServiceRuntimeNetworkResourceGroup: pulumi.String("my-service-runtime-network-rg"),
 * ServiceRuntimeSubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime"),
 * },
 * VnetAddons: &appplatform.ServiceVNetAddonsArgs{
 * DataPlanePublicEndpoint: pulumi.Bool(true),
 * LogStreamPublicEndpoint: pulumi.Bool(true),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * Sku: &appplatform.SkuArgs{
 * Name: pulumi.String("S0"),
 * Tier: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("networkProfile", Map.ofEntries(
 *                     Map.entry("appNetworkResourceGroup", "my-app-network-rg"),
 *                     Map.entry("appSubnetId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps"),
 *                     Map.entry("ingressConfig", Map.of("readTimeoutInSeconds", 300)),
 *                     Map.entry("serviceCidr", "10.8.0.0/16,10.244.0.0/16,10.245.0.1/16"),
 *                     Map.entry("serviceRuntimeNetworkResourceGroup", "my-service-runtime-network-rg"),
 *                     Map.entry("serviceRuntimeSubnetId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime")
 *                 )),
 *                 Map.entry("vnetAddons", Map.ofEntries(
 *                     Map.entry("dataPlanePublicEndpoint", true),
 *                     Map.entry("logStreamPublicEndpoint", true)
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Service myservice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * The GEO location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Service resource
     */
    public val properties: Output<ClusterResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the Service resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the service which is a list of key value pairs that describe the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.azurenative.appplatform.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit):
    Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
