@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AppVNetAddonsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional App settings in vnet injection instance
 * @property publicEndpoint Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
 */
public data class AppVNetAddonsArgs(
    public val publicEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AppVNetAddonsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AppVNetAddonsArgs =
        com.pulumi.azurenative.appplatform.inputs.AppVNetAddonsArgs.builder()
            .publicEndpoint(publicEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppVNetAddonsArgs].
 */
@PulumiTagMarker
public class AppVNetAddonsArgsBuilder internal constructor() {
    private var publicEndpoint: Output<Boolean>? = null

    /**
     * @param value Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
     */
    @JvmName("cfxyfmtpwdhrifqn")
    public suspend fun publicEndpoint(`value`: Output<Boolean>) {
        this.publicEndpoint = value
    }

    /**
     * @param value Indicates whether the App in vnet injection instance exposes endpoint which could be accessed from internet.
     */
    @JvmName("bnqtihktetwrxhrh")
    public suspend fun publicEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicEndpoint = mapped
    }

    internal fun build(): AppVNetAddonsArgs = AppVNetAddonsArgs(
        publicEndpoint = publicEndpoint,
    )
}
