@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BindingResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Binding resource properties payload
 * @property bindingParameters Binding parameters of the Binding resource
 * @property key The key of the bound resource
 * @property resourceId The Azure resource id of the bound resource
 */
public data class BindingResourcePropertiesArgs(
    public val bindingParameters: Output<Map<String, String>>? = null,
    public val key: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BindingResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BindingResourcePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BindingResourcePropertiesArgs.builder()
            .bindingParameters(
                bindingParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .key(key?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BindingResourcePropertiesArgs].
 */
@PulumiTagMarker
public class BindingResourcePropertiesArgsBuilder internal constructor() {
    private var bindingParameters: Output<Map<String, String>>? = null

    private var key: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Binding parameters of the Binding resource
     */
    @JvmName("dvniatauwpnjskfd")
    public suspend fun bindingParameters(`value`: Output<Map<String, String>>) {
        this.bindingParameters = value
    }

    /**
     * @param value The key of the bound resource
     */
    @JvmName("lwsrjklcddnoguex")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The Azure resource id of the bound resource
     */
    @JvmName("miylmvhyvhavfrwd")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Binding parameters of the Binding resource
     */
    @JvmName("werqxkjpgvxetjjg")
    public suspend fun bindingParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingParameters = mapped
    }

    /**
     * @param values Binding parameters of the Binding resource
     */
    @JvmName("fuacjymktnoufjlg")
    public fun bindingParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingParameters = mapped
    }

    /**
     * @param value The key of the bound resource
     */
    @JvmName("wdfwcvjlfeioxdsy")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The Azure resource id of the bound resource
     */
    @JvmName("tqsuoaytehhhiune")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): BindingResourcePropertiesArgs = BindingResourcePropertiesArgs(
        bindingParameters = bindingParameters,
        key = key,
        resourceId = resourceId,
    )
}
