@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource request payload of Build Resource.
 * @property cpu Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m.
 * The default value is 1, this should not exceed build service agent pool cpu size.
 * @property memory Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi.
 * The default value is 2Gi, this should not exceed build service agent pool memory size.
 */
public data class BuildResourceRequestsArgs(
    public val cpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.BuildResourceRequestsArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildResourceRequestsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildResourceRequestsArgs].
 */
@PulumiTagMarker
public class BuildResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m.
     * The default value is 1, this should not exceed build service agent pool cpu size.
     */
    @JvmName("njggkgtxrlckqcem")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi.
     * The default value is 2Gi, this should not exceed build service agent pool memory size.
     */
    @JvmName("aghfkhovinfkftca")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Optional Cpu allocated to the build resource. 1 core can be represented by 1 or 1000m.
     * The default value is 1, this should not exceed build service agent pool cpu size.
     */
    @JvmName("mfropwffqdhoduve")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Optional Memory allocated to the build resource. 1 GB can be represented by 1Gi or 1024Mi.
     * The default value is 2Gi, this should not exceed build service agent pool memory size.
     */
    @JvmName("joxvgcmvuxnfykls")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): BuildResourceRequestsArgs = BuildResourceRequestsArgs(
        cpu = cpu,
        memory = memory,
    )
}
