@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolSizePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Build service agent pool size properties
 * @property name The name of build service agent pool size
 */
public data class BuildServiceAgentPoolSizePropertiesArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolSizePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolSizePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildServiceAgentPoolSizePropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildServiceAgentPoolSizePropertiesArgs].
 */
@PulumiTagMarker
public class BuildServiceAgentPoolSizePropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of build service agent pool size
     */
    @JvmName("cljhwgqsijmdqqkl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of build service agent pool size
     */
    @JvmName("tmdipgkswlujmgjb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BuildServiceAgentPoolSizePropertiesArgs =
        BuildServiceAgentPoolSizePropertiesArgs(
            name = name,
        )
}
