@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Property of git.
 * @property hostKey Public sshKey of git repository.
 * @property hostKeyAlgorithm SshKey algorithm of git repository.
 * @property label Label of the repository
 * @property password Password of git repository basic auth.
 * @property privateKey Private sshKey algorithm of git repository.
 * @property repositories Repositories of git.
 * @property searchPaths Searching path of the repository
 * @property strictHostKeyChecking Strict host key checking or not.
 * @property uri URI of the repository
 * @property username Username of git repository basic auth.
 */
public data class ConfigServerGitPropertyArgs(
    public val hostKey: Output<String>? = null,
    public val hostKeyAlgorithm: Output<String>? = null,
    public val label: Output<String>? = null,
    public val password: Output<String>? = null,
    public val privateKey: Output<String>? = null,
    public val repositories: Output<List<GitPatternRepositoryArgs>>? = null,
    public val searchPaths: Output<List<String>>? = null,
    public val strictHostKeyChecking: Output<Boolean>? = null,
    public val uri: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigServerGitPropertyArgs.builder()
            .hostKey(hostKey?.applyValue({ args0 -> args0 }))
            .hostKeyAlgorithm(hostKeyAlgorithm?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .repositories(
                repositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .searchPaths(searchPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .strictHostKeyChecking(strictHostKeyChecking?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigServerGitPropertyArgs].
 */
@PulumiTagMarker
public class ConfigServerGitPropertyArgsBuilder internal constructor() {
    private var hostKey: Output<String>? = null

    private var hostKeyAlgorithm: Output<String>? = null

    private var label: Output<String>? = null

    private var password: Output<String>? = null

    private var privateKey: Output<String>? = null

    private var repositories: Output<List<GitPatternRepositoryArgs>>? = null

    private var searchPaths: Output<List<String>>? = null

    private var strictHostKeyChecking: Output<Boolean>? = null

    private var uri: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("wepvdayknwpielxq")
    public suspend fun hostKey(`value`: Output<String>) {
        this.hostKey = value
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("lgxghfaputscnnmn")
    public suspend fun hostKeyAlgorithm(`value`: Output<String>) {
        this.hostKeyAlgorithm = value
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("fnhhjcdefutfdnwn")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("kddassmokintmwmg")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("cadsdtqjubxtjvep")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Repositories of git.
     */
    @JvmName("vsrihkxsftnmfwxb")
    public suspend fun repositories(`value`: Output<List<GitPatternRepositoryArgs>>) {
        this.repositories = value
    }

    @JvmName("qkaaopiclrqfuijp")
    public suspend fun repositories(vararg values: Output<GitPatternRepositoryArgs>) {
        this.repositories = Output.all(values.asList())
    }

    /**
     * @param values Repositories of git.
     */
    @JvmName("fsuyxdpuqqmapfsj")
    public suspend fun repositories(values: List<Output<GitPatternRepositoryArgs>>) {
        this.repositories = Output.all(values)
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("lypxxfdyyhciicst")
    public suspend fun searchPaths(`value`: Output<List<String>>) {
        this.searchPaths = value
    }

    @JvmName("cimhyxuudqhbsdvq")
    public suspend fun searchPaths(vararg values: Output<String>) {
        this.searchPaths = Output.all(values.asList())
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("kxlwfnitirrnkcwv")
    public suspend fun searchPaths(values: List<Output<String>>) {
        this.searchPaths = Output.all(values)
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("oewcsipyenfwuswm")
    public suspend fun strictHostKeyChecking(`value`: Output<Boolean>) {
        this.strictHostKeyChecking = value
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("aahulyocpisjsgdg")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("iqpplqkamuycmsli")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Public sshKey of git repository.
     */
    @JvmName("ybxcrvfcpsdblgdw")
    public suspend fun hostKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKey = mapped
    }

    /**
     * @param value SshKey algorithm of git repository.
     */
    @JvmName("oatnqgalpjmgnmyo")
    public suspend fun hostKeyAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKeyAlgorithm = mapped
    }

    /**
     * @param value Label of the repository
     */
    @JvmName("jnkhewkpowaqmyeu")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Password of git repository basic auth.
     */
    @JvmName("axwhsmdxbqqogrvj")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Private sshKey algorithm of git repository.
     */
    @JvmName("gtlkanmtyqilbmkx")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value Repositories of git.
     */
    @JvmName("dbjhsgjrmjueatpm")
    public suspend fun repositories(`value`: List<GitPatternRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of git.
     */
    @JvmName("pxkxqkpaotpydhtg")
    public suspend
    fun repositories(argument: List<suspend GitPatternRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GitPatternRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of git.
     */
    @JvmName("arnyhdbnhccsmrld")
    public suspend fun repositories(
        vararg
        argument: suspend GitPatternRepositoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GitPatternRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param argument Repositories of git.
     */
    @JvmName("exrukohoxkrseaxj")
    public suspend fun repositories(argument: suspend GitPatternRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GitPatternRepositoryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.repositories = mapped
    }

    /**
     * @param values Repositories of git.
     */
    @JvmName("yrvevusexucwqkqu")
    public suspend fun repositories(vararg values: GitPatternRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositories = mapped
    }

    /**
     * @param value Searching path of the repository
     */
    @JvmName("roqmjbmtmwgdjhlc")
    public suspend fun searchPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param values Searching path of the repository
     */
    @JvmName("kkqixxihmhyqflrr")
    public suspend fun searchPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchPaths = mapped
    }

    /**
     * @param value Strict host key checking or not.
     */
    @JvmName("gcwjqkikqanfvyyp")
    public suspend fun strictHostKeyChecking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strictHostKeyChecking = mapped
    }

    /**
     * @param value URI of the repository
     */
    @JvmName("opkgquykeuhouyhc")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Username of git repository basic auth.
     */
    @JvmName("ghpmwwgdjqictnkb")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ConfigServerGitPropertyArgs = ConfigServerGitPropertyArgs(
        hostKey = hostKey,
        hostKeyAlgorithm = hostKeyAlgorithm,
        label = label,
        password = password,
        privateKey = privateKey,
        repositories = repositories,
        searchPaths = searchPaths,
        strictHostKeyChecking = strictHostKeyChecking,
        uri = uri ?: throw PulumiNullFieldException("uri"),
        username = username,
    )
}
