@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The settings of Application Configuration Service.
 * @property gitProperty Property of git environment.
 */
public data class ConfigurationServiceSettingsArgs(
    public val gitProperty: Output<ConfigurationServiceGitPropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigurationServiceSettingsArgs.builder()
            .gitProperty(gitProperty?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationServiceSettingsArgs].
 */
@PulumiTagMarker
public class ConfigurationServiceSettingsArgsBuilder internal constructor() {
    private var gitProperty: Output<ConfigurationServiceGitPropertyArgs>? = null

    /**
     * @param value Property of git environment.
     */
    @JvmName("gmbpdrmpkjgkuduk")
    public suspend fun gitProperty(`value`: Output<ConfigurationServiceGitPropertyArgs>) {
        this.gitProperty = value
    }

    /**
     * @param value Property of git environment.
     */
    @JvmName("jmrlxunpeccuiftu")
    public suspend fun gitProperty(`value`: ConfigurationServiceGitPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitProperty = mapped
    }

    /**
     * @param argument Property of git environment.
     */
    @JvmName("rhxihtganrfmhiio")
    public suspend
    fun gitProperty(argument: suspend ConfigurationServiceGitPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationServiceGitPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitProperty = mapped
    }

    internal fun build(): ConfigurationServiceSettingsArgs = ConfigurationServiceSettingsArgs(
        gitProperty = gitProperty,
    )
}
