@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The basic authentication properties for the container registry resource.
 * @property password The password of the Container Registry.
 * @property server The login server of the Container Registry.
 * @property type The credential type of the container registry credentials.
 * Expected value is 'BasicAuth'.
 * @property username The username of the Container Registry.
 */
public data class ContainerRegistryBasicCredentialsArgs(
    public val password: Output<String>,
    public val server: Output<String>,
    public val type: Output<String>,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs =
        com.pulumi.azurenative.appplatform.inputs.ContainerRegistryBasicCredentialsArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRegistryBasicCredentialsArgs].
 */
@PulumiTagMarker
public class ContainerRegistryBasicCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var type: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password of the Container Registry.
     */
    @JvmName("vpkneylltirrvylo")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The login server of the Container Registry.
     */
    @JvmName("btayfnrxrpjgxdbb")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The credential type of the container registry credentials.
     * Expected value is 'BasicAuth'.
     */
    @JvmName("rfrlokaviasiuspy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The username of the Container Registry.
     */
    @JvmName("qcpwhobxplemfvak")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password of the Container Registry.
     */
    @JvmName("mdopmvmyrkmysmwb")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The login server of the Container Registry.
     */
    @JvmName("qgidgygrrltardgk")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The credential type of the container registry credentials.
     * Expected value is 'BasicAuth'.
     */
    @JvmName("ooegacmlxxieihxq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The username of the Container Registry.
     */
    @JvmName("eeidncwvxromdfxv")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ContainerRegistryBasicCredentialsArgs =
        ContainerRegistryBasicCredentialsArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            server = server ?: throw PulumiNullFieldException("server"),
            type = type ?: throw PulumiNullFieldException("type"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
