@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Container registry resource payload.
 * @property credentials The credentials of the container registry resource.
 */
public data class ContainerRegistryPropertiesArgs(
    public val credentials: Output<ContainerRegistryBasicCredentialsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ContainerRegistryPropertiesArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerRegistryPropertiesArgs].
 */
@PulumiTagMarker
public class ContainerRegistryPropertiesArgsBuilder internal constructor() {
    private var credentials: Output<ContainerRegistryBasicCredentialsArgs>? = null

    /**
     * @param value The credentials of the container registry resource.
     */
    @JvmName("nxneapotikqhhnfn")
    public suspend fun credentials(`value`: Output<ContainerRegistryBasicCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The credentials of the container registry resource.
     */
    @JvmName("hktcwdwwulswogyt")
    public suspend fun credentials(`value`: ContainerRegistryBasicCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials of the container registry resource.
     */
    @JvmName("mhacumonijumbppa")
    public suspend
    fun credentials(argument: suspend ContainerRegistryBasicCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRegistryBasicCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    internal fun build(): ContainerRegistryPropertiesArgs = ContainerRegistryPropertiesArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
    )
}
