@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CustomContainerUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom container user source info
 * @property customContainer Custom container payload
 * @property type Type of the source uploaded
 * Expected value is 'Container'.
 * @property version Version of the source
 */
public data class CustomContainerUserSourceInfoArgs(
    public val customContainer: Output<CustomContainerArgs>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CustomContainerUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.CustomContainerUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.CustomContainerUserSourceInfoArgs.builder()
            .customContainer(customContainer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomContainerUserSourceInfoArgs].
 */
@PulumiTagMarker
public class CustomContainerUserSourceInfoArgsBuilder internal constructor() {
    private var customContainer: Output<CustomContainerArgs>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Custom container payload
     */
    @JvmName("agowuklbpiralqeb")
    public suspend fun customContainer(`value`: Output<CustomContainerArgs>) {
        this.customContainer = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Container'.
     */
    @JvmName("kprdgnypkxrwxpcd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("jvxswqtyuwhdshfq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Custom container payload
     */
    @JvmName("uwgycmvviovjrnes")
    public suspend fun customContainer(`value`: CustomContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customContainer = mapped
    }

    /**
     * @param argument Custom container payload
     */
    @JvmName("nukarmcusfeocqmu")
    public suspend fun customContainer(argument: suspend CustomContainerArgsBuilder.() -> Unit) {
        val toBeMapped = CustomContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customContainer = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Container'.
     */
    @JvmName("klpkpxeitcabutsl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("rlvdcsmfiusojudy")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): CustomContainerUserSourceInfoArgs = CustomContainerUserSourceInfoArgs(
        customContainer = customContainer,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
