@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CustomPersistentDiskResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom persistent disk resource payload.
 * @property customPersistentDiskProperties Properties of the custom persistent disk resource payload.
 * @property storageId The resource id of Azure Spring Apps Storage resource.
 */
public data class CustomPersistentDiskResourceArgs(
    public val customPersistentDiskProperties: Output<AzureFileVolumeArgs>? = null,
    public val storageId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CustomPersistentDiskResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.CustomPersistentDiskResourceArgs =
        com.pulumi.azurenative.appplatform.inputs.CustomPersistentDiskResourceArgs.builder()
            .customPersistentDiskProperties(
                customPersistentDiskProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .storageId(storageId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomPersistentDiskResourceArgs].
 */
@PulumiTagMarker
public class CustomPersistentDiskResourceArgsBuilder internal constructor() {
    private var customPersistentDiskProperties: Output<AzureFileVolumeArgs>? = null

    private var storageId: Output<String>? = null

    /**
     * @param value Properties of the custom persistent disk resource payload.
     */
    @JvmName("ofuiymhanmpxedlw")
    public suspend fun customPersistentDiskProperties(`value`: Output<AzureFileVolumeArgs>) {
        this.customPersistentDiskProperties = value
    }

    /**
     * @param value The resource id of Azure Spring Apps Storage resource.
     */
    @JvmName("suqhdgmymniwimrc")
    public suspend fun storageId(`value`: Output<String>) {
        this.storageId = value
    }

    /**
     * @param value Properties of the custom persistent disk resource payload.
     */
    @JvmName("khsxqlvnoxqhatec")
    public suspend fun customPersistentDiskProperties(`value`: AzureFileVolumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPersistentDiskProperties = mapped
    }

    /**
     * @param argument Properties of the custom persistent disk resource payload.
     */
    @JvmName("ccffvhoijbnfppco")
    public suspend
    fun customPersistentDiskProperties(argument: suspend AzureFileVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileVolumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customPersistentDiskProperties = mapped
    }

    /**
     * @param value The resource id of Azure Spring Apps Storage resource.
     */
    @JvmName("ipwoxivexptxwqly")
    public suspend fun storageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageId = mapped
    }

    internal fun build(): CustomPersistentDiskResourceArgs = CustomPersistentDiskResourceArgs(
        customPersistentDiskProperties = customPersistentDiskProperties,
        storageId = storageId ?: throw PulumiNullFieldException("storageId"),
    )
}
