@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * OpenAPI properties of Spring Cloud Gateway route config.
 * @property uri The URI of OpenAPI specification.
 */
public data class GatewayRouteConfigOpenApiPropertiesArgs(
    public val uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigOpenApiPropertiesArgs.builder()
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteConfigOpenApiPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayRouteConfigOpenApiPropertiesArgsBuilder internal constructor() {
    private var uri: Output<String>? = null

    /**
     * @param value The URI of OpenAPI specification.
     */
    @JvmName("cduuetjeabtgdiki")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The URI of OpenAPI specification.
     */
    @JvmName("ddrsfoseosbclmqp")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): GatewayRouteConfigOpenApiPropertiesArgs =
        GatewayRouteConfigOpenApiPropertiesArgs(
            uri = uri,
        )
}
