@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetDevToolPortalPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devToolPortalName The name of Dev Tool Portal.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetDevToolPortalPlainArgs(
    public val devToolPortalName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetDevToolPortalPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetDevToolPortalPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetDevToolPortalPlainArgs.builder()
            .devToolPortalName(devToolPortalName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevToolPortalPlainArgs].
 */
@PulumiTagMarker
public class GetDevToolPortalPlainArgsBuilder internal constructor() {
    private var devToolPortalName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of Dev Tool Portal.
     */
    @JvmName("jvovlrggjaedktmi")
    public suspend fun devToolPortalName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devToolPortalName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wcuipdpyfoqgapex")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("isakqhupjurytacv")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetDevToolPortalPlainArgs = GetDevToolPortalPlainArgs(
        devToolPortalName = devToolPortalName ?: throw PulumiNullFieldException("devToolPortalName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
