@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetServiceRegistryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property serviceRegistryName The name of Service Registry.
 */
public data class GetServiceRegistryPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val serviceRegistryName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetServiceRegistryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetServiceRegistryPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetServiceRegistryPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .serviceRegistryName(serviceRegistryName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceRegistryPlainArgs].
 */
@PulumiTagMarker
public class GetServiceRegistryPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var serviceRegistryName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nbkjejvaeguwapiw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ilaltknnjnvgeljd")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of Service Registry.
     */
    @JvmName("tpvhkgseuarfmpok")
    public suspend fun serviceRegistryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceRegistryName = mapped
    }

    internal fun build(): GetServiceRegistryPlainArgs = GetServiceRegistryPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        serviceRegistryName = serviceRegistryName ?: throw PulumiNullFieldException("serviceRegistryName"),
    )
}
